@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Upload Lead Data file

                    @foreach (['danger', 'warning', 'success', 'info'] as $key)
                    @if(Session::has($key))
                    <p class="alert alert-{{ $key }} alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;{{ Session::get($key) }}</p>
                    @endif
                    @endforeach

                </div>
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        @foreach ($errors->all() as $error)
                        <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <form action="{{url('import-lead/')}}" method="POST" enctype="multipart/form-data" onsubmit="return Validate(this);">
                    @csrf
                    <div class="col-md-12" style="margin:10px 0;">
                        {{ Form::submit('Upload', array('class' => 'btn btn-default')) }}
                        <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                    </div>


                    <div class="panel-body">

                        <div class="form-group">
                            <label for="title">Excel xlsx or CSV file</label>
                            <input type="file" name="file" id="lead-file" class="form-control">
                        </div>

                    </div>
                </form>

                <div class="panel-body">

                    <table id="tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Filename</th>
                                <th>Created at</th>
                                <th></th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>

                </div>

            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_script')

<script>
    var _validFileExtensions = [".csv", ".xlsx"];

    function Validate(oForm) {

        if ($('#lead-file')[0].files.length === 0) {
            alert("Please upload CSV/XLSX KA file");
            return false;
        }
        var arrInputs = oForm.getElementsByTagName("input");
        for (var i = 0; i < arrInputs.length; i++) {
            var oInput = arrInputs[i];
            if (oInput.type == "file") {
                var sFileName = oInput.value;
                if (sFileName.length > 0) {
                    var blnValid = false;
                    for (var j = 0; j < _validFileExtensions.length; j++) {
                        var sCurExtension = _validFileExtensions[j];
                        if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                            blnValid = true;
                            break;
                        }
                    }

                    if (!blnValid) {
                        alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                        return false;
                    }
                }
            }
        }

        return true;
    }

    $(document).ready(function() {
        var csrfToken = '{{ csrf_token() }}';

        console.log(csrfToken);
        var tbl = $('#tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 2],
                "orderable": false
            }],
            ajax: {
                url: "{{ route('lead.index') }}",
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'file_name',
                    name: 'file_name'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'download',
                    name: 'download'
                }
            ],
            fnDrawCallback: function(oSettings) {

            }
        });

    });
</script>



@endsection