@extends('layouts.app')

@push('head')

<link href="{{ asset('css/addon.css') }}" rel="stylesheet">

<style>
    body {
        background-color: #fff;
        font-family: "Raleway", sans-serif;
    }
</style>

@endpush

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Reset Password</div>

                <div class="panel-body">
                    @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                    <a href=" {{ url('/') }} ">Return to homepage</a>
                    @else
                    <div class="alert alert-info">
                        Your password has expired, please change it.
                    </div>
                    <form class="form-horizontal" method="POST" action="{{ route('password.post_expired') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('current_password') ? ' has-error' : '' }}">
                            <label for="current_password" class="col-md-4 control-label">Current Password</label>

                            <div class="col-md-6">
                                <input id="current_password" type="password" class="form-control" name="current_password" required="">

                                @if ($errors->has('current_password'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('current_password') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                            <label for="password" class="col-md-4 control-label">New Password</label>

                            <div class="col-md-6">
                                <input id="password" type="password" class="form-control" name="password" required="">

                                @if ($errors->has('password'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                                @endif

                                <p id="passwordHelpBlock" class="form-text text-muted">
                                </p>

                                <div id="pswd_info" style="position:static;">
                                    <h4>Your password must be at least 9 Characters long and must meet 3 of 4 of the conditions below:</h4>
                                    <ul>
                                        <li id="upper" class="invalid">At least <strong>one uppercase letter</strong></li>
                                        <li id="lower" class="invalid">At least <strong>one lowercase letter</strong></li>
                                        <li id="number" class="invalid">At least <strong>one number</strong></li>
                                        <li id="special" class="invalid">At least <strong>one special character</strong></li>
                                        <!--<li id="length" class="invalid">Be at least <strong>9 characters</strong></li>-->
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                            <label for="password-confirm" class="col-md-4 control-label">Confirm New Password</label>
                            <div class="col-md-6">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required="">

                                @if ($errors->has('password_confirmation'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('password_confirmation') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Reset Password
                                </button>
                            </div>
                        </div>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('footer')

<script>
    $(".toggle-password").click(function() {

        $(this).toggleClass("fa-eye-slash fa-eye");

        if ($(this).parent().find('#password').attr("type") == "password") {
            $(this).parent().find('#password').attr("type", "text");
            $('#password-confirmation').attr("type", "text");
        } else {
            $(this).parent().find('#password').attr("type", "password");
            $('#password-confirmation').attr("type", "password");
        }
    });
</script>

<script src="{{ asset('js/pswd/validate.js')}}"></script>

@endpush