<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBackofficeGameplay2021 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('backoffice_gameplay_2021', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('cust_id', 255);
            $table->string('dte_id', 255);
            $table->string('contact_id', 255);
            $table->string('first_name', 255);
            $table->string('last_name', 255);
            $table->string('email', 255);
            $table->dateTime('start')->nullable();
            $table->dateTime('game_start')->nullable();
            $table->dateTime('end')->nullable();
            $table->dateTime('game_retry')->nullable();
            $table->string('game', 255);
            $table->integer('score')->nullable();
            $table->integer('points');
            $table->dateTime('send_to_dte')->nullable();
            $table->dateTime('add_to_dte')->nullable();
            $table->longText('dte_message')->nullable();
            $table->string('user_agent', 255);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('backoffice_gameplay');
    }
}
