<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePhotoFeedbackTasks extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photo_feedback_tasks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name', 255);
            $table->string('title', 255);
            $table->text('descr');
            $table->text('campaign_url');
            $table->text('snap_url');
            $table->text('banner_img');
            $table->longText('subchain_id');
            //$table->bigInteger('duration')->comment('24, 48 or 72 hours');
            $table->string('transaction_descr', 255);
            $table->bigInteger('points')->nullable();
            $table->dateTime('start_datetime')->nullable();
            $table->dateTime('end_datetime')->nullable();
            $table->dateTime('reminder_datetime')->nullable();
            $table->text('reminder_sms_en');
            $table->text('reminder_sms_ch');
            $table->text('approval_sms_en');
            $table->text('approval_sms_ch');
            $table->text('rejection_sms_en');
            $table->text('rejection_sms_ch');
            $table->text('task_expired_sms_en');
            $table->text('task_expired_sms_ch');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photo_feedback_tasks');
    }
}
