<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class TradeProgramRetailerClustersBanners extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trade_program_retailer_clusters_banner', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('retailer_cluster_id');
            $table->longText('banner_path');
            $table->longText('banner_path_ch')->nullable();
            $table->integer('target_payout_amount')->nullable();
            $table->integer('cap_payout_amount')->nullable();
            $table->integer('increment_payout_amount')->nullable();
            $table->longText('tips_payout');
            $table->longText('tips_payout_ch')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });

        Schema::table('trade_program_retailer_clusters_banner', function ($table) {
            //default foreign name too long change another one
            $table->foreign('retailer_cluster_id', 'retailer_clusters_banner_foreign')->references('id')->on('trade_program_retailer_clusters');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
