<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTradeProgramTradeMechanics extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trade_program_trade_mechanics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('trade_program_id');
            $table->bigInteger('types_mechanic_id');
            $table->bigInteger('mechanic_id');
            $table->timestamps();
        });

        Schema::table('trade_program_trade_mechanics', function ($table) {
            $table->foreign('trade_program_id')->references('id')->on('trade_program');
            $table->foreign('types_mechanic_id')->references('id')->on('trade_program_types_mechanic');
            $table->foreign('mechanic_id')->references('id')->on('trade_program_mechanics');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trade_mechanics');
    }
}
