<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class CommaDelimiter implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!empty($value)) {
            $valArr = explode(",", $value);

            $emptyFound = false;
            foreach ($valArr as $value) {
                $value = trim($value);
                if (empty($value)) {
                    $emptyFound = true;
                }
            }

            if ($emptyFound == true) {
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Comma delimiter format incorrectly';
    }
}
