<?php

namespace App\Providers;

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //Custom validation
        Schema::defaultStringLength(191);

        Validator::extend('password_histories', function ($attribute, $value, $parameters, $validator) {
            $inputs = $validator->getData();

            if (empty($inputs['email'])) {
                $user = auth()->user();
                $email = $user->email;
            } else {
                $email = $inputs['email'];
            }

            $password = $inputs['password'];

            /*
            $numPass = DB::table('password_histories')->where('email', $email)->count();
            if ($numPass > 0) {
                return false;
            }
            */

            $matched = false;
            $passwordHistories = DB::table('password_histories')->where('email', $email)->take(env('PASSWORD_HISTORY_NUM'))->orderBy('created_at', 'desc')->get();
            foreach ($passwordHistories as $passwordHistory) {
                if (Hash::check($password, $passwordHistory->password)) {
                    // The passwords matches
                    //echo "matched";
                    $matched = true;
                }
            }

            if ($matched) {
                return false;
            } else {
                return true;
            }
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
