<?php

namespace App\Imports;

use App\Models\Gt_tier;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Carbon;

class GTTierImport implements ToModel, WithStartRow, WithMultipleSheets
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function sheets(): array
    {
        return [
            'Tier' => $this,
        ];
    }

    public function model(array $row)
    {
        if ($row[0] != "" and $row[1] != "" and $row[2] != "" and $row[3] != "") {
            return new Gt_tier([
                'customer_code'     => $row[0],
                'customer_name'    => $row[1],
                'status_level' => $row[2],
                'pm_posm'    => $row[3],
                'successful_lead'    => $row[4],
                'base_target_quarterly'    => $row[5],
                'base_target'    => $row[6],
                'last_update'  => $row[7],
                'created_at' => Carbon::now()->format('Y-m-d H:i:s')

            ]);
        }
    }

    public function startRow(): int
    {
        return 2;
    }

    public function batchSize(): int
    {
        return 500;
    }

    public function chunkSize(): int
    {
        return 1000;
    }
}
