<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PasswordExpiredRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return
            [
                'current_password' => 'required',
                //'password' => 'required|confirmed|min:9|regex:/(?=.{9,})((?=.*\d)(?=.*[a-z])|(?=.*\d)(?=.*[a-zA-Z])(?=.*[\W_])|(?=.*[a-z])(?=.*[A-Z])(?=.*[\W_])).*/|password_histories',
                //'password' => ['required', 'min:9', 'regex:/(?=.{9,})((?=.*\d)(?=.*[a-z])|(?=.*\d)(?=.*[a-zA-Z])(?=.*[\W_])|(?=.*[a-z])(?=.*[A-Z])(?=.*[\W_])).*/', 'password_histories'],
                'password' => ['required', 'min:9', 'regex:/((?=.*\d)(?=.*[a-z])(?=.*[A-Z])|(?=.*\d)(?=.*[a-zA-Z])(?=.*[\W_])|(?=.*[a-z])(?=.*[A-Z])(?=.*[\W_])).*/', 'password_histories'],
            ];
    }


    public function messages()
    {
        return [
            'password.password_histories' => 'This password has been used in your last 10 passwords. Please enter another password', // <---- pass a message for your custom validator
        ];
    }
}
