<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use URL;
use View;
use Session;
use App\PhotoFeedbackTasksModel;
use App\PhotoFeedbackSubmissionsModel;
use App\PhotoFeedbackInvoicesSMS;
use App\PhotoFeedbackInvoicesPublish;
use App\Subchain;
use Illuminate\Support\Facades\Input;
use Validator, Redirect, Response, File;
use App\Helpers\DTEdecode;
use App\Helpers\ChkDomain;
use Cache;

class PhotoFeedbackTasksController extends Controller
{

    public $allowed_image_extension = array(
        "png",
        "jpg",
        "jpeg",
        "gif",
        "PNG",
        "JPG",
        "JPEG",
        "GIF"
    );

    public $duration_opt = array(
        array(
            "id" => "24",
            "value" =>  "24",
        ),

        array(
            "id" => "48",
            "value" =>  "48",
        ),

        array(
            "id" => "72",
            "value" =>  "72",
        ),

        array(
            "id" => "336",
            "value" =>  "336",
        )
    );


    public $staticOption = 1;
    public $dynamicOption = 2;

    public function showImage(Request $request)
    {
        $folderName = "snap-banner";

        $chkDomain = new chkDomain();
        $domain = $chkDomain->chkDomain($folderName);

        if (strstr($domain, 'localhost') || strstr($domain, '192.168') || strstr($domain, 'wamp64')) {
            $imgsPath = public_path("imgs/$folderName/");
        } else if (strstr($domain, 'games.pmisg.cloud.sg')) {
            $imgsPath = "../../../imgs/$folderName/";
        } else if (strstr($domain, 'games-staging.pmisg.cloud.sg')) {
            $imgsPath = "../../../imgs/$folderName/";
        }

        if ($request->all()) {
            $imgArr = $request->all();
            $img = $imgArr['img'];
            $fullPath = $imgsPath . $img;
            //$img = readfile("../../../imgs/" . $img);

            ob_end_clean();
            return response()->stream(function () use ($fullPath) {
                echo readfile($fullPath);
            }, 200, ['Content-Type' => 'image/png']);
        }
    }

    public function index()
    {

        if (request()->ajax()) {

            $photoFeedback = DB::connection('mysql')
                ->table('photo_feedback_tasks')
                ->select([
                    'photo_feedback_tasks.id',
                    'photo_feedback_tasks.name',
                    DB::raw('group_concat(trade_program_subchain.name) as subchain'),
                    'photo_feedback_tasks.start_datetime',
                    'photo_feedback_tasks.end_datetime',
                    'photo_feedback_tasks.points',
                    'photo_feedback_tasks.created_at',
                ])
                ->leftJoin('trade_program_subchain', function ($join) {
                    $join->whereRaw("FIND_IN_SET (trade_program_subchain.id, photo_feedback_tasks.subchain_id)");
                })
                ->whereNull('photo_feedback_tasks.deleted_at')
                ->orderBy('created_at', 'DESC')
                ->groupBy('photo_feedback_tasks.id');


            return datatables()->of($photoFeedback)
                ->addColumn('chk_id', function ($row) {
                    return "<input type='checkbox' name='pf-chk-" . $row->id . "' id='pf-chk-" . $row->id . "' value='" . $row->id . "' class='dt-check'>
                                <label for='pf-chk-" . $row->id . "'>
                                    <span></span>
                                </label>";
                })

                ->addColumn('action', function ($row) {
                    $editBtn = auth()->user()->can('edit photo-feedback') ? "<a href='" . URL::to("photo-feedback/tasks/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>" : "";
                    $viewBtn = auth()->user()->can('view photo-feedback') ? "<a href='" . URL::to("photo-feedback/tasks/" . $row->id) . "' class='btn btn-default'>View</a>" : "";
                    return $editBtn . "  " . $viewBtn;
                })
                ->rawColumns(['chk_id', 'action'])
                ->make();
        }
        return view('photo-feedback-tasks.list');
    }

    public function create()
    {
        $allSubchain = DB::table('trade_program_subchain')->orderBy('name', 'asc')->pluck('name', 'id');
        //$durationOpt = $this->duration_opt;

        $allCampaign = DB::table('2022progress_tracker_campaign')->orderBy('id', 'asc')->pluck('name', 'id');
        $allStage = DB::table('2022progress_tracker_stage')->orderBy('id', 'asc')->pluck('stage_name', 'id');

        $allCampaign->prepend('None', '');
        $allStage->prepend('None', '');

        $data = compact("allSubchain", "allCampaign", "allStage");
        return View::make('photo-feedback-tasks.create')->with('data', $data);
    }


    public function store()
    {

        if (Input::get('options') == $this->staticOption) {

            $rules = array(
                'name' => 'required|unique:photo_feedback_tasks,name,NULL,,deleted_at,NULL',
                'banner_img' => 'required',
                'banner_img_ch' => 'required',
                'title' => 'required',
                'descr' => 'required',
                'campaign_url' => 'required',
                'snap_url' => 'required',
                'subchain' => 'required',
                //'duration' => 'required',
                'transaction_descr' => 'required',
                'points' => 'required',
                'start_datetime' => 'required',
                'end_datetime' => 'required',
                'reminder_datetime' => 'required',
                'reminder_sms_en' => 'required',
                'reminder_sms_ch' => 'required',
                'approval_sms_en' => 'required',
                'approval_sms_ch' => 'required',
                'rejection_sms_en' => 'required',
                'rejection_sms_ch' => 'required',
                //'task_expired_sms_en' => 'required',
                //'task_expired_sms_ch' => 'required'
            );
        } else {
            $rules = array(
                'name' => 'required|unique:photo_feedback_tasks,name,NULL,,deleted_at,NULL',
                'banner_img' => 'required',
                'banner_img_ch' => 'required',
                'title' => 'required',
                'descr' => 'required',
                'campaign_url' => 'required',
                'snap_url' => 'required',
                'subchain' => 'required',
                'transaction_descr' => 'required',
                'points' => 'required',
                'task_duration' => 'required',
                'reminder_sms_day' => 'required',
                'dynamic_end_datetime' => 'required',
                'reminder_sms_en' => 'required',
                'reminder_sms_ch' => 'required',
                'approval_sms_en' => 'required',
                'approval_sms_ch' => 'required',
                'rejection_sms_en' => 'required',
                'rejection_sms_ch' => 'required',
            );
        }

        $customMessages = [
            'name.required' => 'The Photo Feedback Task Name field is required.',
            'transaction_descr.required' => 'The Transacaction Description is required.',
            'subchain.required' => 'The Subchain field is required.',
        ];

        $validator = Validator::make(Input::all(), $rules, $customMessages);

        // process the store
        if ($validator->fails()) {
            return Redirect::to('photo-feedback/tasks/create')
                ->withErrors($validator)
                ->withInput();
        } else {

            // store
            $pf = new PhotoFeedbackTasksModel;
            $pf->name = Input::get('name');
            $pf->title = Input::get('title');
            $pf->descr = Input::get('descr');
            $pf->campaign_id = (!empty(Input::get('campaign_id'))) ? Input::get('campaign_id') : null;
            $pf->campaign_stage_id =  (!empty(Input::get('campaign_stage_id'))) ? Input::get('campaign_stage_id') : null;
            $pf->campaign_task_type =  (!empty(Input::get('campaign_task_type'))) ? Input::get('campaign_task_type') : null;
            $pf->campaign_url = Input::get('campaign_url');
            $pf->snap_url = Input::get('snap_url');
            //$pf->duration = Input::get('duration');
            $pf->transaction_descr = Input::get('transaction_descr');
            $pf->points = Input::get('points');
            $pf->options = Input::get('options');

            if (Input::get('options') == $this->staticOption) {
                $pf->start_datetime = Input::get('start_datetime');
                $pf->end_datetime = Input::get('end_datetime');
                $pf->reminder_datetime = Input::get('reminder_datetime');

                $pf->task_duration = null;
                $pf->reminder_sms_day = null;
                $pf->dynamic_end_datetime = null;
            } else {
                $pf->start_datetime = null;
                $pf->end_datetime = null;
                $pf->reminder_datetime = null;

                $pf->task_duration = Input::get('task_duration');
                $pf->reminder_sms_day = Input::get('reminder_sms_day');
                $pf->dynamic_end_datetime = Input::get('dynamic_end_datetime');
            }

            $pf->reminder_datetime = Input::get('reminder_datetime');

            //define image path
            $chkDomain = new chkDomain();
            $bannerImgsPath = $chkDomain->chkDomain("snap-banner");
            $statement = DB::select("show table status like 'photo_feedback_tasks'");
            $nextIncrementId =  $statement[0]->Auto_increment;

            if (Input::file('banner_img')) {

                $files = Input::file('banner_img');

                $fileSize = $files->getSize();
                $file_extension =  $files->getClientOriginalExtension();

                if (!in_array($file_extension, $this->allowed_image_extension)) {
                    DB::rollBack();
                    return response()->json(['status' => false, 'message' => "Upload valiid images. Only PNG, JPG, JPEG and GIF are allowed."]);
                } else if (($fileSize > 2000000)) { //Image size exceeds 2MB
                    DB::rollBack();
                    return response()->json(['status' => false, 'message' => "Image size exceeds 2MB."]);
                } else {
                    // Define upload path
                    $path = $bannerImgsPath . $nextIncrementId . '/banner';
                    $absoPath = $nextIncrementId . '/banner';
                    File::makeDirectory($path, $mode = 0777, true, true);
                    $destinationPath = $path;

                    // Upload Orginal Image  
                    $fileInfo = $files->getClientOriginalName();
                    $filename = pathinfo($fileInfo, PATHINFO_FILENAME);
                    $image = date('YmdHis') . "-" . uniqid() . "-" .  $filename . "." . $files->getClientOriginalExtension();
                    $files->move($destinationPath, $image);

                    $ImagePath = $absoPath . "/" . $image;
                    $pf->banner_img = "$ImagePath";
                }
            }

            if (Input::file('banner_img_ch')) {


                $files = Input::file('banner_img_ch');

                $fileSize = $files->getSize();
                $file_extension =  $files->getClientOriginalExtension();

                if (!in_array($file_extension, $this->allowed_image_extension)) {
                    return response()->json(['status' => false, 'message' => "Upload valiid images. Only PNG, JPG, JPEG and GIF are allowed."]);
                } else if (($fileSize > 2000000)) { //Image size exceeds 2MB
                    return response()->json(['status' => false, 'message' => "Image size exceeds 2MB."]);
                } else {
                    // Define upload path
                    $path = $bannerImgsPath . $nextIncrementId . '/banner-ch';
                    $absoPath = $nextIncrementId . '/banner-ch';
                    File::makeDirectory($path, $mode = 0777, true, true);
                    $destinationPath = $path;

                    // Upload Orginal Image  
                    $fileInfo = $files->getClientOriginalName();
                    $filename = pathinfo($fileInfo, PATHINFO_FILENAME);
                    $image = date('YmdHis') . "-" . uniqid() . "-" .  $filename . "." . $files->getClientOriginalExtension();
                    $files->move($destinationPath, $image);

                    $ImagePath = $absoPath . "/" . $image;
                    $pf->banner_img_ch = "$ImagePath";
                }
            }

            //SMS templates
            $pf->reminder_sms_en = Input::get('reminder_sms_en');
            $pf->reminder_sms_ch = Input::get('reminder_sms_ch');
            $pf->approval_sms_en = Input::get('approval_sms_en');
            $pf->approval_sms_ch = Input::get('approval_sms_ch');
            $pf->rejection_sms_en = Input::get('rejection_sms_en');
            $pf->rejection_sms_ch = Input::get('rejection_sms_ch');
            $pf->task_expired_sms_en = Input::get('task_expired_sms_en');
            $pf->task_expired_sms_ch = Input::get('task_expired_sms_ch');

            if (!empty(Input::get('subchain'))) {
                $subchainArr = Input::get('subchain');
                sort($subchainArr);
                $pf->subchain_id = implode(",", $subchainArr);
            } else {
                $pf->subchain_id = "";
            }

            $pf->save();

            // redirect
            Session::flash('success', $pf->name . ' successfully created Photo Feedback Task Name!');
            return Redirect::to('photo-feedback/tasks');
        }
    }

    public function edit($id)
    {
        $pf = PhotoFeedbackTasksModel::find($id);
        $allSubchain = DB::table('trade_program_subchain')->orderBy('name', 'asc')->pluck('name', 'id');
        $allCampaign = DB::table('2022progress_tracker_campaign')->orderBy('id', 'asc')->pluck('name', 'id');
        $allStage = DB::table('2022progress_tracker_stage')->orderBy('id', 'asc')->pluck('stage_name', 'id');

        $allCampaign->prepend('None', '');
        $allStage->prepend('None', '');

        //$durationOpt = $this->duration_opt;
        $data = compact("allSubchain", "allCampaign", "allStage", "pf");
        return View::make('photo-feedback-tasks.edit')->with('data', $data);
    }

    public function update(Request $request, $id)
    {

        if (Input::get('options') == $this->staticOption) {
            $rules = array(
                'name' => 'required|unique:photo_feedback_tasks,name,' . $id . ',,deleted_at,NULL',
                //'banner_img' => 'required',
                //'banner_img_ch' => 'required',
                'title' => 'required',
                'descr' => 'required',
                'campaign_url' => 'required',
                'snap_url' => 'required',
                'subchain' => 'required',
                //'duration' => 'required',
                'transaction_descr' => 'required',
                'points' => 'required',
                'start_datetime' => 'required',
                'end_datetime' => 'required',
                'reminder_datetime' => 'required',
                'reminder_sms_en' => 'required',
                'reminder_sms_ch' => 'required',
                'approval_sms_en' => 'required',
                'approval_sms_ch' => 'required',
                'rejection_sms_en' => 'required',
                'rejection_sms_ch' => 'required',
                //'task_expired_sms_en' => 'required',
                //'task_expired_sms_ch' => 'required'
            );
        } else {
            $rules = array(
                'name' => 'required|unique:photo_feedback_tasks,name,' . $id . ',,deleted_at,NULL',
                'title' => 'required',
                'descr' => 'required',
                'campaign_url' => 'required',
                'snap_url' => 'required',
                'subchain' => 'required',
                'transaction_descr' => 'required',
                'points' => 'required',
                'task_duration' => 'required',
                'reminder_sms_day' => 'required',
                'dynamic_end_datetime' => 'required',
                'reminder_sms_en' => 'required',
                'reminder_sms_ch' => 'required',
                'approval_sms_en' => 'required',
                'approval_sms_ch' => 'required',
                'rejection_sms_en' => 'required',
                'rejection_sms_ch' => 'required',
            );
        }

        $customMessages = [
            'name.required' => 'The Photo Task name field is required.',
            'transaction_descr.required' => 'The Transacaction Description is required.',
            'subchain.required' => 'The Subchain field is required.',
        ];

        $validator = Validator::make(Input::all(), $rules, $customMessages);

        // process the store
        if ($validator->fails()) {
            return Redirect::to('photo-feedback/tasks/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput();
        } else {

            // store
            $pf = PhotoFeedbackTasksModel::find($id);
            $pf->name = Input::get('name');
            $pf->title = Input::get('title');
            $pf->descr = Input::get('descr');
            $pf->campaign_id = (!empty(Input::get('campaign_id'))) ? Input::get('campaign_id') : null;
            $pf->campaign_stage_id =  (!empty(Input::get('campaign_stage_id'))) ? Input::get('campaign_stage_id') : null;
            $pf->campaign_task_type =  (!empty(Input::get('campaign_task_type'))) ? Input::get('campaign_task_type') : null;
            $pf->campaign_url = Input::get('campaign_url');
            $pf->snap_url = Input::get('snap_url');
            //$pf->duration = Input::get('duration');
            $pf->transaction_descr = Input::get('transaction_descr');
            $pf->points = Input::get('points');
            $pf->options = Input::get('options');

            if (Input::get('options') == $this->staticOption) {
                $pf->start_datetime = Input::get('start_datetime');
                $pf->end_datetime = Input::get('end_datetime');
                $pf->reminder_datetime = Input::get('reminder_datetime');

                $pf->task_duration = null;
                $pf->reminder_sms_day = null;
                $pf->dynamic_end_datetime = null;
            } else {

                $pf->start_datetime = null;
                $pf->end_datetime = null;
                $pf->reminder_datetime = null;

                $pf->task_duration = Input::get('task_duration');
                $pf->reminder_sms_day = Input::get('reminder_sms_day');
                $pf->dynamic_end_datetime = Input::get('dynamic_end_datetime');
            }

            //SMS templates
            $pf->reminder_sms_en = Input::get('reminder_sms_en');
            $pf->reminder_sms_ch = Input::get('reminder_sms_ch');
            $pf->approval_sms_en = Input::get('approval_sms_en');
            $pf->approval_sms_ch = Input::get('approval_sms_ch');
            $pf->rejection_sms_en = Input::get('rejection_sms_en');
            $pf->rejection_sms_ch = Input::get('rejection_sms_ch');
            $pf->task_expired_sms_en = Input::get('task_expired_sms_en');
            $pf->task_expired_sms_ch = Input::get('task_expired_sms_ch');

            if (!empty(Input::get('subchain'))) {
                $subchainArr = Input::get('subchain');
                sort($subchainArr);
                $pf->subchain_id = implode(",", $subchainArr);
            } else {
                $pf->subchain_id = "";
            }


            //define image path
            $chkDomain = new chkDomain();
            $bannerImgsPath = $chkDomain->chkDomain("snap-banner");
            $statement = DB::select("show table status like 'photo_feedback_tasks'");
            $nextIncrementId =  $statement[0]->Auto_increment;

            if (Input::file('banner_img')) {

                $files = Input::file('banner_img');

                $fileSize = $files->getSize();
                $file_extension =  $files->getClientOriginalExtension();

                if (!in_array($file_extension, $this->allowed_image_extension)) {
                    return response()->json(['status' => false, 'message' => "Upload valiid images. Only PNG, JPG, JPEG and GIF are allowed."]);
                } else if (($fileSize > 2000000)) { //Image size exceeds 2MB
                    return response()->json(['status' => false, 'message' => "Image size exceeds 2MB."]);
                } else {
                    // Define upload path
                    $path = $bannerImgsPath . $nextIncrementId . '/banner';
                    $absoPath = $nextIncrementId . '/banner';
                    File::makeDirectory($path, $mode = 0777, true, true);
                    $destinationPath = $path;

                    // Upload Orginal Image  
                    $fileInfo = $files->getClientOriginalName();
                    $filename = pathinfo($fileInfo, PATHINFO_FILENAME);
                    $image = date('YmdHis') . "-" . uniqid() . "-" .  $filename . "." . $files->getClientOriginalExtension();
                    $files->move($destinationPath, $image);

                    $ImagePath = $absoPath . "/" . $image;
                    $pf->banner_img = "$ImagePath";
                }
            }

            if (Input::file('banner_img_ch')) {


                $files = Input::file('banner_img_ch');

                $fileSize = $files->getSize();
                $file_extension =  $files->getClientOriginalExtension();

                if (!in_array($file_extension, $this->allowed_image_extension)) {
                    return response()->json(['status' => false, 'message' => "Upload valid images. Only PNG, JPG, JPEG and GIF are allowed."]);
                } else if (($fileSize > 2000000)) { //Image size exceeds 2MB
                    return response()->json(['status' => false, 'message' => "Image size exceeds 2MB."]);
                } else {
                    // Define upload path
                    $path = $bannerImgsPath . $nextIncrementId . '/banner-ch';
                    $absoPath = $nextIncrementId . '/banner-ch';
                    File::makeDirectory($path, $mode = 0777, true, true);
                    $destinationPath = $path;

                    // Upload Orginal Image  
                    $fileInfo = $files->getClientOriginalName();
                    $filename = pathinfo($fileInfo, PATHINFO_FILENAME);
                    $image = date('YmdHis') . "-" . uniqid() . "-" .  $filename . "." . $files->getClientOriginalExtension();
                    $files->move($destinationPath, $image);

                    $ImagePath = $absoPath . "/" . $image;
                    $pf->banner_img_ch = "$ImagePath";
                }
            }

            $pf->save();

            // redirect
            Session::flash('success', $pf->name . ' successfully edited Photo Feedback Task!');
            return Redirect::to('photo-feedback/tasks');
        }
    }

    public function deleteMultiple(Request $request)
    {

        $ids = $request->id;

        $rcName = DB::table('photo_feedback_tasks')
            ->select([DB::raw('group_concat(name) as names')])
            ->whereIn('id', $ids)->first();

        PhotoFeedbackTasksModel::whereIn('id', $ids)->delete();
        return response()->json(['status' => true, 'message' => "Task ($rcName->names) deleted successfully."]);
    }



    public function viewIframe($id, Request $request)
    {

        if (!empty($id)) {

            if ($request->has('query')) {
                $query = $request->input('query');

                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);

                $data = array(
                    'success' => false,
                    "task" => $id,
                    'locale' => "",
                    'snap_url' => "",
                    'img' => "",
                    'button_text' => "",
                    'button_color' => "",
                    'status_name' => "",
                    'task_over' => "",
                    'current_datetime' => "",
                    'close_datetime' => "",
                    'remain_day' => "",
                );


                if ($decryptedData == false) {
                    return view('photo-feedback-iframe.index')->with('data', $data);
                } else {


                    $locale = $decryptedData->User->LanguageLocaleKey;
                    $subchain = $decryptedData->User->Contact->Account->DTE_Sub_Chain__c;
                    $custId = $decryptedData->User->Contact->Account->DTE_AccountNumber__c;
                    $custId = substr($custId, 2);

                    $comingSoon = false;
                    $taskOver = false;

                    //$subchain = "7-11"; //hardcode

                    //$duration = 336; //after 2 weeks program end ((14*24)/2 )
                    $taskData = PhotoFeedbackTasksModel::getTaskDataById($id);  //for example duration is 336 hours;

                    $diff = "";

                    if (sizeof($taskData) <= 0) {
                        return view('photo-feedback-iframe.index')->with('data', $data);
                    } else {
                        $taskData = $taskData[0];
                        $taskId = $taskData['id'];
                        $bannerImg = $taskData['banner_img'];
                        $bannerImgCH = $taskData['banner_img_ch'];
                        $snapUrl = $taskData['snap_url'];
                        $startDatetime = substr($taskData['start_datetime'], 0, -3);
                        $endDatetime = substr($taskData["end_datetime"], 0, -3);
                        $options = $taskData['options'];
                        $taskDuration = $taskData['task_duration'];
                        $dynamicEndDatetime = $taskData['dynamic_end_datetime'];
                        $reminderSmsDay = $taskData['reminder_sms_day'];
                        $subchainId = $taskData['subchain_id'];

                        // hardcode
                        //$subchain = "GPRIC";

                        $taskSubchainIdArr = explode(",", $subchainId);
                        $subchainData = Subchain::where('name', $subchain)->first();

                        // Check subchain
                        if (!empty($subchainData)) {
                            if (!in_array($subchainData->id, $taskSubchainIdArr)) {
                                return view('photo-feedback-iframe.index')->with('data', $data);
                            }
                        } else {
                            return view('photo-feedback-iframe.index')->with('data', $data);
                        }
                    }

                    $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

                    // if Static option
                    if ($this->staticOption == $options) {

                        // $currentYear = Carbon::now()->year;
                        // $invoiceDate_year = $currentYear;
                        // $invoiceDate_mth = 7; //July
                        // $invoiceDate_date = 26;
                        // $invoiceHour = 9;
                        // $invoiceMin = 0;

                        //$closeDatetime = Carbon::create($invoiceDate_year, $invoiceDate_mth, $invoiceDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');

                        if ($currentDateTime >= $endDatetime) {

                            $day = (int)0;
                            $hours = (int)0;
                            $mins = (int)0;

                            $taskOver = true;
                        } else {
                            $endDate = Carbon::parse($endDatetime);
                            $now = Carbon::now("Asia/Singapore");

                            $diff = $now->diff($endDate, false)->format('%I');
                            //$close_time_remaining = $now->diffInHours($endDate) . ' hours ' . $diff . ' minutes';

                            $hours = $now->diffInHours($endDate);
                            $dayHours = 24; //one day 24 hours

                            $remainDays = 0;
                            $remainHours = 0;
                            $remainMins = $diff;

                            if ($hours > $dayHours) {
                                $days = (int)($hours / $dayHours);
                                $totalHours = $hours % $dayHours;

                                $remainDays = $days;
                                $remainHours = $totalHours;
                            } else {
                                $remainDays = 0;
                                $remainHours = $hours;
                            }

                            $day = (int)$remainDays;
                            $hours = (int)$remainHours;
                            $mins = (int)$remainMins;

                            // Before start datetime
                            if (Carbon::now() < $startDatetime) { // haven't start yet (coming soon)
                                $comingSoon = true;
                            }
                        }
                    } else {  // if dynamic option

                        // Dynamic end date
                        if ($currentDateTime > $dynamicEndDatetime) {
                            return view('photo-feedback-iframe.index')->with('data', $data);
                        }

                        $now = Carbon::now("Asia/Singapore");
                        $taskEnd = Carbon::now()->addDays($taskDuration);
                        $smsFireDay = Carbon::now()->addDays($reminderSmsDay);

                        // Check invoice date
                        $data = PhotoFeedbackInvoicesPublish::where('cust_id', $custId)
                            ->first();

                        if (!empty($data->published_date)) {

                            $releaseDatetime = $data->published_date;
                            $taskEnd = Carbon::parse($releaseDatetime)->addDays($taskDuration);
                            $smsFireDay = Carbon::parse($releaseDatetime)->addDays($reminderSmsDay);

                            $hours = $now->diffInHours($taskEnd);
                            $dayHours = 24; //one day 24 hours

                            $remainDays = 0;
                            $remainHours = 0;
                            $remainMins = $now->diff($taskEnd, false)->format('%I');

                            if ($hours > $dayHours) {
                                $days = (int)($hours / $dayHours);
                                $totalHours = $hours % $dayHours;

                                $remainDays = $days;
                                $remainHours = $totalHours;
                            } else {
                                $remainDays = 0;
                                $remainHours = $hours;
                            }

                            $day = (int)$remainDays;
                            $hours = (int)$remainHours;
                            $mins = (int)$remainMins;

                            // after start datetime
                            if (Carbon::now() >= $releaseDatetime) {

                                if (Carbon::now() > $taskEnd) {
                                    $taskOver = true;
                                }
                            } else if (Carbon::now() < $releaseDatetime) { // haven't start yet (coming soon)
                                $comingSoon = true;
                            }
                        } else {
                            $day = 0;
                            $hours = 0;
                            $mins = 0;
                            $comingSoon = true;
                            //return view('photo-feedback-iframe.index')->with('data', $data);
                        }
                    }

                    // check status - Approved pr Disapproved
                    $pfStatus = PhotoFeedbackSubmissionsModel::getStatus($custId, $taskId);

                    $disapproveMsg = "";

                    if (count($pfStatus)) {
                        $status = $pfStatus[0]['status'];
                        $approved =  PhotoFeedbackSubmissionsModel::$approved;
                        $disapproved =  PhotoFeedbackSubmissionsModel::$disapproved;

                        $pfErrorMsg = PhotoFeedbackSubmissionsModel::select('descr', 'ch_descr', 'created_at')
                            ->leftJoin('photo_feedback_error_msg', 'photo_feedback_error_msg.id', '=', 'photo_feedback_submissions.error_msg')
                            ->where('cust_id', $custId)
                            ->where('task_id', $taskId)
                            ->orderBy('created_at', 'desc')
                            ->first();

                        $buttonText = "";
                        $buttonColor = "";

                        switch ($locale) {
                            case "en_SG":
                                if (is_null($status)) {
                                    $buttonText = "Pending <br> Approval";
                                    $buttonColor = "#c60d14";
                                    $statusName = "Pending";
                                } else {
                                    switch ($status) {
                                        case $disapproved:
                                            $buttonText = "Resubmit";
                                            $buttonColor = "#c60d14";
                                            $statusName = "Rejected";

                                            $createdAt = Carbon::createFromFormat('Y-m-d H:i:s', $pfErrorMsg->created_at)->format('Y M d H:i:s');
                                            $disapproveMsg = nl2br("Submission Error on " . $createdAt . "\n" . $pfErrorMsg->descr);
                                            break;
                                        case $approved:
                                            $buttonText = "Completed";
                                            $buttonColor = "#C1C1C1";
                                            $statusName = "Approved";
                                            break;
                                    }
                                }
                                break;
                            case "zh_SG":
                                if (is_null($status)) {
                                    $buttonText = "待批准";
                                    $buttonColor = "#c60d14";
                                    $statusName = "Pending";
                                } else {
                                    switch ($status) {
                                        case $disapproved:
                                            $buttonText = "重新提交";
                                            $buttonColor = "#c60d14";
                                            $statusName = "Rejected";

                                            $createdAt = Carbon::createFromFormat('Y-m-d H:i:s', $pfErrorMsg->created_at)->format('Y M d H:i:s');
                                            $disapproveMsg = nl2br("提交错误于 " . $createdAt . "\n"  . $pfErrorMsg->ch_descr);
                                            break;
                                        case $approved:
                                            $buttonText = "任务完成";
                                            $buttonColor = "#C1C1C1";
                                            $statusName = "Approved";
                                            break;
                                    }
                                }
                                break;
                        }
                    } else { //before 1st try,

                        if ($comingSoon == false) {
                            $statusName = "Start";
                            switch ($locale) {
                                case "en_SG":
                                    $buttonText = "Start";
                                    $buttonColor = "#c60d14";
                                    break;
                                case "zh_SG":
                                    $buttonText = "开始";
                                    $buttonColor = "#c60d14";
                                    break;
                            }
                        } else {
                            $statusName = "Coming Soon";
                            $snapUrl = "";
                            switch ($locale) {
                                case "en_SG":
                                    $buttonText = "Coming Soon";
                                    $buttonColor = "#C1C1C1";
                                    break;
                                case "zh_SG":
                                    $buttonText = "即将推出";
                                    $buttonColor = "#C1C1C1";
                                    break;
                            }
                        }
                    }

                    $imgName = "";
                    $remainDay  = "";
                    switch ($locale) {
                        case "en_SG":
                            $imgName = url("snap-banner/image?img=" . urlencode($bannerImg));
                            $remainDay = $day . " day(s) " . $hours . " hours " . $mins . " mins";
                            break;
                        case "zh_SG":
                            $imgName =  url("snap-banner/image?img=" . urlencode($bannerImgCH));
                            $remainDay = $day . " 天 " . $hours . " 小时 " . $mins . " 分钟";
                            break;
                    }



                    $data = array(
                        'success' => true,
                        "task" => $id,
                        'locale' => $locale,
                        'snap_url' => $snapUrl,
                        'img' => $imgName,
                        'button_text' => $buttonText,
                        'button_color' => $buttonColor,
                        'status_name' => $statusName,
                        'task_over' => $taskOver,
                        'current_datetime' => $currentDateTime,
                        'close_datetime' => $endDatetime,
                        'remain_day' => $remainDay,
                        'coming_soon' => $comingSoon,
                        'disapprove_msg' => $disapproveMsg
                    );


                    return view('photo-feedback-iframe.index')->with('data', $data);
                }
            }
        }
    }


    public function store_task(Request $request)
    {
        if ($request->has('task_id')) {

            $taskId = $request->input('task_id');

            Cache::put('task_id', $taskId);

            //setcookie($cookie_name, $cookie_value, time() + 3600, "/; SameSite=None; Secure");
            $cookieName = "task_id";
            //setcookie($cookieName, $taskId, time() + 3600, "SameSite=None;Secure;");

            // updated by 2022 Jan 26
            setcookie($cookieName, $taskId, time() + 3600);

            if (Cache::has('task_id')) {
                $value = Cache::get('task_id');

                return response()->json(array(
                    'success' => TRUE,
                    'message' => 'Task (' . $value . ') saved successfully.',
                ), 200);
            } else {
                return response()->json(array(
                    'success' => TRUE,
                    'message' => 'Task saved failed.',
                ), 200);
            }
        }
    }

    public function show($id)
    {
        $pf = PhotoFeedbackTasksModel::find($id);
        $allSubchain = DB::table('trade_program_subchain')->orderBy('name', 'asc')->pluck('name', 'id');

        $allCampaign = DB::table('2022progress_tracker_campaign')->orderBy('id', 'asc')->pluck('name', 'id');
        $allStage = DB::table('2022progress_tracker_stage')->orderBy('id', 'asc')->pluck('stage_name', 'id');

        $allCampaign->prepend('None', '');
        $allStage->prepend('None', '');

        $data = compact("allSubchain", "pf", "allCampaign", "allStage");
        return View::make('photo-feedback-tasks.view')->with('data', $data);
    }
}
