<?php

namespace App\Http\Controllers;

use App\Code;
use App\Imports\PfImport;
use App\Models\Pf_files;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Response;
use Session;

class PfController extends Controller
{
    public $carton = 20;

    public function importView()
    {
        return view('pf.import');
    }

    public function index()
    {

        if (request()->ajax()) {
            $pf = DB::connection('mysql')
                ->table('pf_files')
                ->select(['id', 'file_name', 'created_at'])
                ->orderByDesc('created_at');

            return datatables()->of($pf)
                ->addColumn('download', function ($row) {
                    if (auth()->user()->can('import loyalty')) {
                        return "<a href='" . url("api/download-pf-files/" . $row->id) . "' class='btn btn-default'>Download</a>";
                    }
                })
                ->rawColumns(['download'])
                ->make(true);
        }

        return view('pf.import');
    }

    public function download_pf_file($fileId)
    {

        $filesInfo = Pf_files::find($fileId);

        $path = storage_path() . '/' . 'app' . '/pf-files/' . $filesInfo->file_name;
        if (file_exists($path)) {
            ob_end_clean();
            return Response::download($path);
        }
    }

    public function import(Request $request)
    {

        //ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ini_set('mysql.connect_timeout', '0');
        ini_set('max_execution_time', '0');
        ini_set('default_socket_timeout', 9000);

        if ($request->hasFile('file')) {

            DB::beginTransaction();

            try {

                Code::truncate();
                $ee = Excel::import(new PfImport, request()->file('file'));

                $fileOriginName = $request->file('file')->getClientOriginalName();
                $saveFileName = Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;
                $path = $request->file('file')->storeAs(
                    'pf-files',
                    $saveFileName
                );

                $path = storage_path('app/' . $path);

                $pfFile = new Pf_files;

                $pfFile->file_name = $saveFileName;
                $pfFile->path_name = $path;
                $pfFile->updated_at = null;
                $pfFile->save();

		Session::flash('success', 'PF file uploaded!');
		DB::commit();

            } catch (QueryException $ex) {
                DB::rollback();
                Session::flash()->error('PF file failed! ' . $ex);
            }

            return back();
        }
    }
}
