<?php

namespace App\Http\Controllers;

use App\Permission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use App\Authorizable;
use URL;
use View;
use Session;
use Redirect;

class PermissionsListController extends Controller
{
    use Authorizable;

    public $status = array(0 => "Inactive", 1 => "Active");

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        if (request()->ajax()) {
            $user = DB::connection('mysql')
                ->table('permissions')
                ->select(['id', 'name']);

            return datatables()->of($user)
                /*
                ->addColumn('status', function($row) {
                    return $this->status[$row->status];
                })
                */
                ->addColumn('chk_id', function ($row) {
                    return "<input type='checkbox' name='permission-chk-" . $row->id . "' id='permission-chk-" . $row->id . "' value='" . $row->id . "' class='dt-check'>
                            <label for='permission-chk-" . $row->id . "'>
                                <span></span>
                            </label>";
                })
                ->addColumn('action', function ($row) {
                    if (auth()->user()->can('edit permissions')) {
                        return "<a href='" . URL::to("permissions/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>";
                    }
                })
                ->rawColumns(['chk_id', 'status', 'action'])
                ->make();;
        }
    }

    public function show()
    {
        return view('permissions.index');
    }

    public function create()
    {
        //$status = $this->status;
        //return View::make('permissions.create')->with(compact("status"));
        return View::make('permissions.create');
    }

    public function store()
    {
        // validate

        $rules = array(
            'name' => 'required|unique:permissions',
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('permissions/create')
                ->withErrors($validator)
                ->withInput();
        } else {
            // store
            $permission = new Permission;
            $permission->name = Input::get('name');
            $permission->save();

            // redirect
            Session::flash('success', $permission->name . ' successfully created Permission!');
            return Redirect::to('permissions/list');
        }
    }

    public function edit($id)
    {
        // get the Doc
        $permission = Permission::find($id);
        $status = $this->status;
        // show the edit form and pass the doc
        return View::make('permissions.edit')
            ->with('permission', $permission);
    }

    public function update($id)
    {
        $rules = array(
            'name' => 'required|unique:permissions,name,' . $id,
            //'description' => 'required',
            //'status' => 'required'
        );
        $validator = Validator::make(Input::all(), $rules);

        if ($validator->fails()) {

            return Redirect::to('permissions/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput();
        } else {
            // store
            $permission = Permission::find($id);
            $permission->name = Input::get('name');
            //$permission->permission_desc = Input::get('description');
            //$permission->status = Input::get('status');
            $permission->save();

            // redirect
            Session::flash('success', 'Successfully updated ' . $permission->name . ' permission!');
            return Redirect::to('permissions/list');
        }
    }

    public function deleteMultiple(Request $request)
    {

        $ids = $request->id;

        Permission::whereIn('id', $ids)->delete();
        return response()->json(['status' => true, 'message' => "Permission(s) deleted successfully."]);
    }
}
