<?php

namespace App\Http\Controllers;

use App\Doc;
use App\Authorizable;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\SoftDeletes;
use Redirect;
use View;
use Session;
use URL;

class DocController extends Controller
{
    //
    use SoftDeletes;

    use Authorizable;

    public function __construct(){
        $this->middleware('auth');
    }

    public function index(){

        if (request()->ajax()){
            $doc = DB::connection('mysql')
                   ->table('docs')
                   ->select(['id', 'header', 'desc', 'author', 'created_at'])
                   ->whereNull('docs.deleted_at');

            return datatables()->of($doc)
            ->addColumn('chk_id', function($row) {
                return "<input type='checkbox' name='doc-chk-".$row->id."' id='doc-chk-".$row->id."' value='".$row->id."' class='dt-check'>
                        <label for='doc-chk-".$row->id."'>
                            <span></span>
                        </label>";
            })
            ->addColumn('action', function($row) {

                $editBtn = auth()->user()->can('edit documentation') ? "<a href='". URL::to("documentation/".$row->id."/edit") ."' class='btn btn-default'>Edit</a>" : "" ;
                return "<a data-id='".$row->id."' data-toggle='modal' data-target='#viewModal' class='btn btn-default viewBtn'>View</a> 
                        $editBtn ";
            })
            ->rawColumns(['chk_id', 'action'])
            ->make(true);
        }
        
        return view('doc.doc');
    }

    public function create(){
        return View::make('doc.create');
    }

    public function store(){
        // validate

        $rules = array(
            'title' => 'required',
            'description' => 'required',
            'content' => 'required',
            'author' => 'required'
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('documentation/create')
                ->withErrors($validator)
                ->withInput(Input::except('password'));
        } else {
            // store
            $doc = new Doc;
            $doc->header = Input::get('title');
            $doc->desc = Input::get('description');
            $doc->content = Input::get('content');
            $doc->author = Input::get('author');
            $doc->save();

            // redirect
            Session::flash('success', $doc->header.' successfully created document!');
            return Redirect::to('documentation');
        }
        
    }

    public function edit($id)
    {
        // get the Doc
        $doc = Doc::find($id);

        // show the edit form and pass the doc
        return View::make('doc.edit')
            ->with('doc', $doc);
    }

    public function update($id)
    {
        $rules = array(
            'title' => 'required',
            'description' => 'required',
            'content' => 'required',
            'author' => 'required'
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('documentation/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput(Input::except('password'));
        } else {
            // store
            $doc = Doc::find($id);
            $doc->header = Input::get('title');
            $doc->desc = Input::get('description');
            $doc->content = Input::get('content');
            $doc->author = Input::get('author');
            $doc->save();

            // redirect
            Session::flash('success', 'Successfully updated '.$doc->header.' document!');
            return Redirect::to('documentation');
        }
    }

    public function destroy($id)
    {
        // delete
        $doc = Doc::find($id);
        $doc->softDeletes();
        //$doc->delete();

        // redirect
        Session::flash('message', 'Successfully deleted the document!');
        return Redirect::to('documentation');
    }

    public function deleteMultiple(Request $request){

        $ids = $request->id;
    
        Doc::whereIn('id',$ids)->delete();
        return response()->json(['status'=>true,'message'=>"Documents deleted successfully."]);   

    }

}
