<?php

namespace App\Helpers;  //this was missing in your code

class SmsDome
{
    private $url = 'http://www.smsdome.com/api/http/sendsms.aspx';
    private $app_id = '2285';
    private $app_secret = '3a4651dd-646f-46c6-976c-52f439183a26';

    public function __construct($url = NULL, $app_id = NULL, $app_secret = NULL)
    {
        $this->url = !empty($url) ? $url : $this->url;
        $this->app_id = !empty($app_id) ? $app_id : $this->app_id;
        $this->app_secret = !empty($app_secret) ? $app_secret : $this->app_secret;
    }

    public function log_error($message)
    {
        $sms_log_filename = 'sms-' . date('Y-m-d') . '.log';
        $logPath = storage_path('smsdome/' . $sms_log_filename);

        if (!file_exists($logPath)) {
            $sms_log = fopen($logPath, 'w+');
            fwrite($sms_log, $message . "\r\n");
        } else {
            $sms_log = fopen($logPath, 'a+');
            fwrite($sms_log, $message . "\r\n");
        }

        fclose($sms_log);
    }

    public function send_sms($receivers, $message, $auto_log = TRUE)
    {
        // 100 recipients per HTTP request
        $fields = array(
            'appid' => urlencode($this->app_id),
            'appsecret' => urlencode($this->app_secret),
            'receivers' => urlencode($receivers),
            'content' => urlencode($message),
            'responseformat' => 'JSON'
        );

        $fields_string = '';

        //url-ify the data for the POST
        foreach ($fields as $key => $value) {
            $fields_string .= $key . '=' . $value . '&';
        }

        $fields_string = rtrim($fields_string, '&');

        //open connection
        $ch = curl_init();

        //set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_POST, count($fields));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        //curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, FALSE);
        //execute post
        $json_result = curl_exec($ch);
        /*$json_result = json_encode(array('sent'=>TRUE,
                                         'message' => $message), JSON_UNESCAPED_SLASHES);*/

        $sms_log_filename = 'sms-' . date('Y-m-d') . '.log';
        $logPath = storage_path('smsdome/' . $sms_log_filename);

        if (!empty($json_result)) {
            if ($auto_log) {
                if (!file_exists($logPath)) {
                    $sms_log = fopen($logPath, 'w+');
                    fwrite($sms_log, "[" . date('d/m/Y H:i:s') . "] " . $json_result . "\r\n");
                } else {
                    $sms_log = fopen($logPath, 'a+');
                    fwrite($sms_log, "[" . date('d/m/Y H:i:s') . "] " . $json_result . "\r\n");
                }

                fclose($sms_log);
                return $json_result;
            } else {
                return $json_result;
            }
        } else {
            return 'Error parsing json result';
        }

        //close connection
        curl_close($ch);
    }
}
