<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\GtPastIncentive;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;


use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ImportGTPastIncentive extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:importGTPastIncentive';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import GT Past Incentive';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/gt-past-incentive/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/gt-past-incentive/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'GT-Past-Incentive-history-' . $log_date;
        $log = new Logger('GT-Past-Incentive-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('Start importing GT-Past-Incentive...');

        try {

            $files = scandir('/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/app/gt-past-incentive-files', SCANDIR_SORT_DESCENDING);
            $newest_file = $files[0];

            $path = storage_path('app/gt-past-incentive-files/' . $newest_file);

            GtPastIncentive::truncate();

            $collection = (new FastExcel)->import($path);
            $collection->filter()->each(function ($line) {

                GtPastIncentive::create([
                    'customer_code' => $line['CustomerCode'],
                    'customer_name' => $line['CustomerName'],
                    'base_target_month' => $line['Base Target Month'],
                    'base_target' => $line['Base Target'],
                    'product_price_segment_desc' => $line['ProductPriceSegmentDescription'],
                    'product_family_desc' => $line['ProductFamilyDescription'],
                    'time_id' => $line['TimeId'],
                    'ims' => $line['IMS'],
                    'buy_enough_rebate' => $line['Buy Enough Rebate'],
                    'buy_above_rebate' => $line['Buy Above Rebate'],
                    'total_rebate' => $line['Total Rebate'],
                    'chain' => $line['Chain'],
                    'created_at' => Carbon::now()->format('Y-m-d H:i:s')
                ]);
            });

            $log->info('GT-Past-Incentive imported successfully.');
        } catch (\Exception $ex) {
            $log->critical('GT-Past-Incentive imported failed.' . $ex);
        }
    }
}
