<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">

                <div class="panel-heading">Photo Feedback Tasks
                    <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(Session::has($key)): ?>
                    <p class="alert alert-<?php echo e($key); ?> alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<?php echo e(Session::get($key)); ?></p>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="col-md-12" style="margin:10px 0;">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit photo-feedback')): ?>
                    <a href="<?php echo e(route('tasks.create')); ?>" class="btn btn-default"><i class="glyphicon glyphicon-plus"></i> Create</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete photo-feedback')): ?>
                    <button type="button" id="deleteTask" class="deleteBtn float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>
                    <?php endif; ?>
                </div>

                <br>

                <div class="panel-body">
                    <!--
                    <div id="accordion">
                        <h3 class="filter-header"><i class="fa fa-filter" aria-hidden="true"></i> Filter <i class="fa fa-sort-down"></i></h3>
                        <div id="filter-container">
                            <div class="col-md-6 filter-col-1">

                            </div>
                            <div class="col-md-6 filter-col-2">

                            </div>
                        </div>
                    </div>
                    -->

                    <table id="pf-task-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th style="width:5%;">
                                    <input id="multi-all" class="dt-check" type="checkbox">
                                    <label for="multi-all">
                                        <span></span>
                                    </label>
                                </th>
                                <th>Task ID</th>
                                <th>Name</th>
                                <th>Subchain</th>
                                <th>Points</th>
                                <th>Start</th>
                                <th>End</th>
                                <th>Created Datetime</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>

                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="deleteModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><i class="fa fa-trash" aria-hidden="true"></i> Delete this Photo Feedback Task?</h4>
                    </div>
                    <div id="modal-body" class="modal-body">
                        <p>Are you sure, you want to delete the selected Photo feedback task?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="confirmDelTask" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>

<div class="spinner-border" style="width: 3rem; height: 3rem;" role="status">
    <span class="sr-only">Loading...</span>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>

<link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>">
<script src="<?php echo e(asset('js/jquery-ui/jquery-ui.js')); ?>"></script>

<script type="text/javascript">
    var base_url = "<?php echo e(url('/')); ?>";

    $(document).ready(function() {

        $(".alert-msg").fadeOut(5500, function() {
            $(this).remove();
        });

        $("#accordion").accordion({
            collapsible: true,
            active: false
        });

        $("#deleteTask").click(function() {
            var chk_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            if (chk_ids > 0) {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected Task? (NOTED: It might affect the Photo feedback audience)</p>");
            } else {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected Task? (NOTED: It might affect the Photo feedback audience)</p>");
            }
        });

        //$('#pf-task-tbl tr').clone(true).appendTo('#filter-temp-tbl thead');

        var tp_tbl = $('#pf-task-tbl').DataTable({
            //scrollX: true,
            //dom: '<"top"l>rt<"bottom"p><"clear">',
            serverSide: true,
            processing: true,
            bStateSave: false,
            stateSave: true,
            responsive: true,
            autoWidth: true,
            bInfo: false,
            columnDefs: [{
                "targets": [0, 2],
                "orderable": false
            }],
            ajax: {
                url: "<?php echo e(route('tasks.index')); ?>",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [{
                    data: 'chk_id',
                    name: 'chk_id'
                },
                {
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'subchain',
                    name: 'subchain'
                },
                {
                    data: 'points',
                    name: 'points'
                },
                {
                    data: 'start_datetime',
                    name: 'start_datetime'
                },
                {
                    data: 'end_datetime',
                    name: 'end_datetime'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'action',
                    name: 'action'
                }

            ],
            fnDrawCallback: function(oSettings) {
                //bindDelete();
            },
            initComplete: function(settings, json) {

                $("#pf-task-tbl").css("width", "100%");

            }
        });

        $("#confirmDelTask").click(function() {

            var chk_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: "<?php echo e(route('photo-feedback-task.multiple-delete')); ?>",
                type: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: chk_ids
                },
                success: function(result) {
                    $(".dt-check:checked").each(function() {
                        tp_tbl.row($(this).parents("tr")).remove().draw();
                    });
                    $(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;' + result.message + '</p>');
                    $(".alert-msg").fadeOut(5500, function() {
                        $(this).remove();
                    });
                }
            });

            var x$;
            x$ = $(this).data('action');
            $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
            $('#multi-val').val(JSON.stringify({
                action: x$,
                id: $('.dt-check:checked:not(#multi-all)').map(function() {
                    return $(this).val();
                }).get()
            }));
            //$('#multi-sub').trigger('click');

        });


        $('body').on('change', '#multi-all', function() {
            var a, b;
            a = $('.dt-check:not(#multi-all)');
            b = $('#deleteTask');
            if ($('#multi-all:checked').length) {
                a.not(':checked').prop('checked', true);
                b.removeClass('disabled').removeAttr('disabled');
                b.css({
                    "background-color": "#B83131",
                    "color": "#fff"
                });
            } else {
                a.filter(':checked').prop('checked', false);
                b.addClass('disabled').attr('disabled', 'disabled');
                b.css({
                    "background-color": "#fff",
                    "color": "#B83131"
                });
            }
        });

        $('body').on('change', '.dt-check:not(#multi-all)', function() {
            var m, b, that, x$;
            m = $('#multi-all');
            b = $('#deleteTask');
            if (that = $('.dt-check:checked:not(#multi-all)').length) {
                x$ = that < $('.dt-check:not(#multi-all)').length;
                m.prop('indeterminate', x$).prop('checked', !x$);
                b.removeClass('disabled').removeAttr('disabled');
                b.css({
                    "background-color": "#B83131",
                    "color": "#fff"
                });
            } else {
                m.prop('indeterminate', false).prop('checked', false);
                b.addClass('disabled').attr('disabled', 'disabled');
                b.css({
                    "background-color": "#fff",
                    "color": "#B83131"
                });
            }
        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/photo-feedback-tasks/list.blade.php ENDPATH**/ ?>