<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'PMI BackOffice')); ?></title>

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/AdminLTE.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/skin-black.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/addon.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/font-awesome.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto+Condensed&display=swap" rel="stylesheet">

    <!-- Datatables responsive -->
    <link href="<?php echo e(asset('css/datatables-responsive/fixedHeader.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/datatables-responsive/responsive.bootstrap.min.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('header_css'); ?>

    <!-- Scripts -->
    <script>
        window.Laravel = <?php echo json_encode([
                                'csrfToken' => csrf_token(),
                            ]); ?>
    </script>
</head>

<body class="skin-black">
    <div id="app">
        <header class="main-header">
            <!-- Logo -->
            <a href="<?php echo e(url('/home')); ?>" class="logo">
                <!-- mini logo for sidebar mini 50x50 pixels -->
                <span class="logo-mini">
                    <b>BackOffice</b>
                </span>
                <!-- logo for regular state and mobile devices -->
                <span class="logo-lg"><img src="<?php echo e(url('/imgs/PMInUtransparent.png')); ?> " /></span>
            </a>
            <!-- Header Navbar: style can be found in header.less -->
            <nav class="navbar navbar-static-top" role="navigation">
                <!-- Sidebar toggle button-->
                <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        <!-- User Account: style can be found in dropdown.less -->
                        <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <i class="fa fa-user"></i>
                                <?php
                                $unwanted_char = array('[', ']', '"');
                                $role_name = str_replace($unwanted_char, "", auth()->user()->getRoleNames());
                                ?>
                                <small class="hidden-xs"><?php if(!empty(Auth::user()->name)): ?> <?php echo e(Auth::user()->name); ?> <?php endif; ?> </small>
                            </a>
                            <ul class="dropdown-menu">
                                <!-- User image -->
                                <li class="user-header">
                                    <p>
                                        <br>
                                        <i class="fa fa-user fa-3x text-white"></i>
                                        <small>Created on
                                            <br>
                                            <!--10/03/2016 12:00 AM-->
                                            <br>
                                            <!--(Active)-->
                                        </small>
                                    </p>
                                </li>
                                <!-- Menu Footer-->
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <span class="badge badge-info" style="background-color:#17a2b8;"><?php echo e($role_name); ?></span>
                                    </div>
                                    <div class="pull-right">
                                        <a href="<?php echo e(url('/logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                            Logout
                                        </a>

                                        <form id="logout-form" action="<?php echo e(url('/logout')); ?>" method="POST" style="display: none;">
                                            <?php echo e(csrf_field()); ?>

                                        </form>
                                    </div>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <!-- Right Side Of Navbar -->
        

    </div>
    </div>
    </nav>

    

    <!--<div class="container-fluid" id="container-fluid">-->
    <?php echo $__env->yieldContent('content'); ?>
    <!--</div>-->

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <?php echo $__env->yieldContent('footer_script'); ?>

</body>

</html>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/layouts/master.blade.php ENDPATH**/ ?>