<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Photo Feedback Submission &nbsp;&nbsp;
                    <span id="status-badge" class="badge"></span>
                    <?php if($data->status === 1): ?>
                    <span id="approve-badge" class="badge badge-success">Approved</span>
                    <?php elseif($data->status === 0): ?>
                    <span id="approve-badge" class="badge badge-danger">Reject</span>
                    <?php endif; ?>
                </div>

                <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><i class="fa-li fa fa-exclamation-triangle"></i><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>

                <?php echo e(Form::model($data, array('url' => array('faulty-dispenser', $data->id), 'method' => 'PUT'))); ?>

                <div class="col-md-12" style="margin:10px 0;">
                    <a href="<?php echo e(url('/photo-feedback/submissions')); ?>" class="btn btn-default">Back</a>
                </div>


                <div class="panel-body fd-form">

                    <div class="form-group">
                        <label for="task_id">Task ID</label>
                        <input type="text" name="task_id" class="form-control" id="task-id" value="<?php echo e($data['task_id']); ?>" readonly>
                    </div>

                    <div class="form-group">
                        <label for="task_id">Task Name</label>
                        <input type="text" name="task_name" class="form-control" id="task-name" value="<?php echo e($task_name); ?>" readonly>
                    </div>

                    <div class="form-group">
                        <label for="cust_id">Cust ID</label>
                        <input type="text" name="cust_id" class="form-control" id="cust-id" value="<?php echo e($data->cust_id); ?>" readonly>
                    </div>

                    <div class="form-group">
                        <label for="contact-no">Contact No</label>
                        <input type="text" name="contact_no" class="form-control" id="contact-no" value="<?php echo e($data->contact_no); ?>" readonly>
                    </div>

                    <?php if($data->checked_by): ?>

                    <div class="form-group approved-info">
                        <label for="approved-by">Approved By</label>
                        <input type="text" name="checked_by" class="form-control" id="approved-by" value="<?php echo e($data->checked_by); ?>" readonly>
                    </div>

                    <?php endif; ?>

                    <?php if($data->checked_datetime): ?>

                    <div class="form-group approved-info">
                        <label for="approved-datetime">Approved Date</label>
                        <input type="text" name="checked_datetime" class="form-control" id="approved-datetime" value="<?php echo e($data->checked_datetime); ?>" readonly>
                    </div>

                    <?php endif; ?>

                    <div class="form-group">
                        <div>
                            <label for="images">Images</label>
                        </div>
                        <?php if(!empty($data->imgs)): ?>
                        <?php $__currentLoopData = json_decode($data->imgs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class='view-img' data-toggle="modal" data-target='#viewModal'>
                            <!-- <img src="<?php echo e(url('imgs/faulty-dispenser/'.$data->case_id.'/'.$img)); ?>" class="dispenser-img" /> -->
                            <img src="<?php echo e(url($img)); ?>" class="dispenser-img" />
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <p>NA</p>
                        <?php endif; ?>
                    </div>

                    <?php if($data->error_msg): ?>
                    <div class="form-group">
                        <label for="error-msg">Rejection Message</label>
                        <?php $__currentLoopData = $error_msg_opt; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kv => $vl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($kv === $data->error_msg): ?>
                        <input type="text" name="error_msg_field" class="form-control" id="error-msg-field" value="<?php echo e($vl); ?>" readonly>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>

                    <div class="form-group">
                        <ul class="list-group">


                            <li class="list-group-item">
                                <!-- <?php echo e(Form::submit('Update Status', array('id' => 'submit-btn', 'class' => 'btn btn-default'))); ?> -->
                                <a class="btn btn-success btn-approve" data-toggle='modal' data-target='#approveModal'>APPROVED</a>
                                <a class="btn btn-danger btn-disapprove" data-toggle='modal' data-target='#disapproveModal'>REJECT</a>
                                <span id="end-notification">Event Closed (2 Aug 2021)</span>
                            </li>

                        </ul>
                    </div>


                </div>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Image modal -->
<div class="modal fade" id="viewModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div id="modal-body" class="modal-xml modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="approveModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Approve?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure? SMS will send to this retailers user.</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-approve" class="btn btn-default btn-approve" data-id="<?php echo e($data->id); ?>" data-status="1" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>

        </div>

    </div>
</div>

<div class="modal fade" id="disapproveModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Disapprove?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure? Rejection SMS will be sent to the retailer. Please select one of the relevant rejection messages to be displayed below the DTE platform SNAP banner.</p>
                <select name="error-msg" id="error-msg" class="form-control">
                    <!--<option selected disabled>Please select</option>-->
                    <?php $__currentLoopData = $error_msg_opt; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kv => $vl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($kv); ?>"><?php echo e($vl); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-disapprove" class="btn btn-default btn-disapprove" data-id="<?php echo e($data->id); ?>" data-status="0" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>

        </div>

    </div>
</div>

<style>
    .dispenser-img {
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 5px;
        width: 200px;
    }

    img:hover {
        opacity: 0.5;
        cursor: pointer;
    }

    #modal-body img {
        width: 100%;
    }

    #end-notification {
        display: none;
        margin-left: 20px;
        color: red;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>
<script src="<?php echo e(asset('vendor/unisharp/laravel-ckeditor/ckeditor.js')); ?>"></script>
<script>
    var userId = "<?php echo e($userId); ?>";
    var flagStatus = "<?php echo e($status); ?>";
    var disableApproveBtn = "<?php echo e($disableApproveBtn); ?>";

    $(function() {

        // if (disableApproveBtn == true) {
        //     $("#btn-approve").css({
        //         "pointer-events": "none",
        //         "cursor": "default",
        //         "opacity": "0.5"
        //     });
        //     $("#end-notification").show();
        // }

        if ($("#approve-badge, #disapprove-badge").length > 0) {
            $(".btn-approve, .btn-disapprove").css({
                "pointer-events": "none",
                "cursor": "default",
                "opacity": "0.5"
            });
        }

        // switch (parseInt(flagStatus)) {
        //     case 0:
        //     case 1:
        //         $("#btn-approve, #btn-disapprove").css({
        //             "pointer-events": "none",
        //             "cursor": "default",
        //             "opacity": "0.5"
        //         });
        //         break;
        // }

        $('#submit-btn').on('click', function(e) {
            if (!confirm('Are you sure approved this submission?')) {
                e.preventDefault();
            }
        });

        $(".view-img").click(function() {
            var src = $(this).find('img').attr('src');
            $("#viewModal #modal-body").html("<img src='" + src + "' />");
        })

        $("#btn-approve, #btn-disapprove").click(function() {
            //if (confirm('Are you sure? SMS will send to this retailers user.')) {
            var id = $(this).data("id");
            var status = $(this).data("status");

            if ($(this).attr('id') == 'btn-disapprove') {
                var postData = {
                    csrf_token: "<?php echo e(csrf_token()); ?>",
                    user_id: userId,
                    status: status,
                    error_msg: $("#error-msg option:selected").val()
                };
            } else {
                var postData = {
                    csrf_token: "<?php echo e(csrf_token()); ?>",
                    user_id: userId,
                    status: status
                };
            }

            $.ajax({
                url: "<?php echo e(url('api/photo-feedback/approved')); ?>" + "/" + id,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: postData,
                success: function(result) {
                    console.log(result);
                    if (result.success) {
                        alert(result.message);
                        location.reload();
                    } else {
                        console.log(result);
                        alert(result.message + "!");
                    }
                },
                error: function(xhr, status, error) {
                    alert(xhr.status + " error. ");
                }
            });
            //}
        })
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/photo-feedback-submissions/edit.blade.php ENDPATH**/ ?>