<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Upload GT Data file

                    <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(Session::has($key)): ?>
                    <p class="alert alert-<?php echo e($key); ?> alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<?php echo e(Session::get($key)); ?></p>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><i class="fa-li fa fa-exclamation-triangle"></i><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>

                <form action="<?php echo e(url('import-gt/')); ?>" method="POST" enctype="multipart/form-data" onsubmit="return Validate(this);">
                    <?php echo csrf_field(); ?>
                    <div class="col-md-12" style="margin:10px 0;">
                        <?php echo e(Form::submit('Upload', array('class' => 'btn btn-default'))); ?>

                        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-default">Back</a>
                    </div>


                    <div class="panel-body">

                        <div class="form-group">
                            <label for="title">Excel xlsx or CSV file</label>
                            <input type="file" name="file" id="gt-file" class="form-control">
                        </div>

                    </div>
                </form>

                <div class="panel-body">

                    <table id="tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Filename</th>
                                <th>Created at</th>
                                <th></th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>

                </div>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>

<script>
    var _validFileExtensions = [".csv", ".xlsx"];

    function Validate(oForm) {

        if ($('#gt-file')[0].files.length === 0) {
            alert("Please upload CSV/XLSX GT file");
            return false;
        }
        var arrInputs = oForm.getElementsByTagName("input");
        for (var i = 0; i < arrInputs.length; i++) {
            var oInput = arrInputs[i];
            if (oInput.type == "file") {
                var sFileName = oInput.value;
                if (sFileName.length > 0) {
                    var blnValid = false;
                    for (var j = 0; j < _validFileExtensions.length; j++) {
                        var sCurExtension = _validFileExtensions[j];
                        if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                            blnValid = true;
                            break;
                        }
                    }

                    if (!blnValid) {
                        alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                        return false;
                    }
                }
            }
        }

        return true;
    }

    $(document).ready(function() {
        var csrfToken = '<?php echo e(csrf_token()); ?>';

        console.log(csrfToken);
        var tbl = $('#tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 2],
                "orderable": false
            }],
            ajax: {
                url: "<?php echo e(route('gt.index')); ?>",
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'file_name',
                    name: 'file_name'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'download',
                    name: 'download'
                }
            ],
            fnDrawCallback: function(oSettings) {

            }
        });

    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/gt/import.blade.php ENDPATH**/ ?>