@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Create User details</div>
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        @foreach ($errors->all() as $error)
                        <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                {{ Form::open(array('url' => 'user-creation')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::to('/user-creation') }}" class="btn btn-default">Back</a>
                </div>

                <div class="panel-body">

                    <div class="form-group">
                        <label for="title">Name</label>
                        <input type="text" name="name" class="form-control" id="name" placeholder="Name" value="{{ old('name') }}">
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}" />
                    </div>

                    <!--
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" class="form-control" id="password" placeholder="Password" value="">
                        <span class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                    </div>

                    <div id="pswd_info">
                        <h4>Password must meet the following requirements:</h4>
                        <ul>
                            <li id="upper" class="invalid">At least <strong>one uppercase letter</strong></li>
                            <li id="lower" class="invalid">At least <strong>one lowercase letter</strong></li>
                            <li id="number" class="invalid">At least <strong>one number</strong></li>
                            <li id="special" class="invalid">At least <strong>one special character</strong></li>
                            <li id="length" class="invalid">Be at least <strong>9 characters</strong></li>
                        </ul>
                    </div>

                    <div class="form-group">
                        <label for="password">Confirm Password</label>
                        <input type="password" name="password_confirmation" class="form-control" id="password-confirmation" placeholder="Confirm password" value="">
                    </div>
                    -->

                    @php
                    $readonlyRoleStatus = true;
                    @endphp

                    @can('edit user-creation-role')
                    @php
                    $readonlyRoleStatus = false;
                    @endphp
                    @endcan

                    @php
                    $disabledRole = ($readonlyRoleStatus == true) ? "disabled" : "" ;
                    @endphp

                    @if(!$disabledRole)
                    <div class="form-group">
                        <label for="content">Role</label>
                        <select name="role_id" id="role" class="form-control" data-old="{{ old('roles') }}" {{ $disabledRole }}>
                            <option selected disabled>Please Select Role</option>
                            @foreach($roles as $r => $vl)
                            <option value="{{ $r }}">{{ $vl }}</option>
                            @endforeach
                        </select>
                    </div>

                    @endif

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_script')

<script>
    $(".toggle-password").click(function() {

        $(this).toggleClass("fa-eye-slash fa-eye");

        if ($(this).parent().find('#password').attr("type") == "password") {
            $(this).parent().find('#password').attr("type", "text");
            $('#password-confirmation').attr("type", "text");
        } else {
            $(this).parent().find('#password').attr("type", "password");
            $('#password-confirmation').attr("type", "password");
        }
    });
</script>

@push('scripts')
<script src="{{ asset('js/pswd/validate.js')}}"></script>
@endpush

@endsection