
@extends('layouts.master')



@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Create Document</div>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="fa-ul">
                            @foreach ($errors->all() as $error)
                                <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{ Form::open(array('url' => 'documentation')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                </div>
  

                <div class="panel-body">

                    <div class="form-group">
                        <label for="title">Title</label>
                        <input type="text" name="title" class="form-control" id="title" placeholder="Title" value="{{ old('title') }}">
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description">{{ old('description') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="content">Content</label>
                        <textarea class="form-control" id="content" name="content">{{ old('content') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="author">Author</label>
                        <input type="text" name="author" class="form-control" id="author" placeholder="Author" value="{{ old('author') }}">
                    </div>

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_script')
<script src="{{ asset('vendor/unisharp/laravel-ckeditor/ckeditor.js') }}"></script>
<script>
    CKEDITOR.replace( 'content' );
</script>
@endsection
