<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePermissionGroupMap extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permission_group_map', function (Blueprint $table) {
            $table->unsignedInteger('permission_group_id');
            $table->unsignedInteger('permission_id');
        });

        Schema::table('permission_group_map', function (Blueprint $table) {
            $table->foreign('permission_group_id')
                  ->references('id')->on('permission_group')
                  ->onDelete('cascade');
            $table->foreign('permission_id')
                  ->references('id')->on('permission')
                  ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permission_group_map');
    }
}
