<?php

namespace App\Http\Controllers;

//use App\Doc;
use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Pf;
use App\Imports\GTBuyImport;
use App\Imports\GTTierImport;
use App\Models\Gt_buy;
use App\Models\Gt_tier;
use App\Models\Gt_files;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Response;
use Webklex\IMAP\Facades\Client;
use App\Helpers\Gmail;


use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class PfController extends Controller
{
    public $carton = 20;

    public function importView()
    {
        return view('pf.import');
    }

    // public function import()
    // {
    //     Excel::import(new UsersImport, request()->file('file'));

    //     return back();
    // }


    public function index()
    {

        if (request()->ajax()) {
            $pf = DB::connection('mysql')
                ->table('pf_files')
                ->select(['id', 'file_name', 'created_at'])
                ->orderByDesc('created_at');

            return datatables()->of($pf)
                ->addColumn('download', function ($row) {
                    if (auth()->user()->can('import loyalty')) {
                        return "<a href='" . url("api/download-pf-files/" . $row->id) . "' class='btn btn-default'>Download</a>";
                    }
                })
                ->rawColumns(['download'])
                ->make(true);
        }

        return view('pf.import');
    }

    public function download_pf_file($fileId)
    {

        $filesInfo = Gt_files::find($fileId);

        $path = storage_path() . '/' . 'app' . '/gt-files/' . $filesInfo->file_name;
        if (file_exists($path)) {
            ob_end_clean();
            return Response::download($path);
        }
    }

    public function import(Request $request)
    {

        //ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ini_set('mysql.connect_timeout', '0');
        ini_set('max_execution_time', '0');
        ini_set('default_socket_timeout', 9000);

        if ($request->hasFile('file')) {

            DB::beginTransaction();

            try {

                Gt_buy::truncate();
                // Excel::import(new GTBuyImport, request()->file('file'));

                // Gt_tier::truncate();
                // Excel::import(new GTTierImport, request()->file('file'));

                // $users = (new FastExcel)->import($request->file('file'), function ($line) {
                //     return Gt_buy::create([
                //         'customer_code' => $line['CustomerCode'],
                //         'customer_name' => $line['CustomerName'],
                //         'base_target_month' => $line['Base Target Month'],
                //         'base_target' => $line['Base Target'],
                //         'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                //         'product_family_descr' => $line['ProductFamilyDescription'],
                //         'time_id' => $line['TimeId'],
                //         'ims' => $line['IMS'],
                //     ]);
                // });

                // $file      = $request->file('file');
                // $fileOriginName = $request->file('file')->getClientOriginalName();
                // $fileExtension = $file->getClientOriginalExtension();
                // $fileName   = time() . '-' . Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;



                // Storage::disk('local')->put('gt-files/' . '/', $fileName, 'public');

                // $path = storage_path('app/gt-files/' . $fileName);
                //$path = $request->file('file')->store('gt-files');

                $fileOriginName = $request->file('file')->getClientOriginalName();
                $saveFileName = Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;
                $path = $request->file('file')->storeAs(
                    'gt-files',
                    $saveFileName
                );

                $path = storage_path('app/' . $path);
                //Excel::import(new GTBuyImport, $path);
                //Excel::import(new GTTierImport, $path);

                //DB::table('gt_buy')->truncate();
                //DB::table('gt_tier')->truncate();

                $gtFile = new Gt_files;

                $gtFile->file_name = $saveFileName;
                $gtFile->path_name = $path;
                $gtFile->updated_at = null;
                $gtFile->save();

                // $BuyCollection = (new FastExcel)->sheet(1)->import($path);
                // $BuyCollection->filter()->each(function ($line) {
                //     Gt_buy::create([
                //         'customer_code' => $line['CustomerCode'],
                //         'customer_name' => $line['CustomerName'],
                //         'base_target_month' => $line['Base Target Month'],
                //         'base_target' => $line['Base Target'],
                //         'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                //         'product_family_descr' => $line['ProductFamilyDescription'],
                //         'time_id' => $line['TimeId'],
                //         'ims' => $line['IMS']
                //     ]);
                // });


                // $tierCollection = (new FastExcel)->sheet(2)->import($path);
                // $tierCollection->filter()->each(function ($line) {
                //     Gt_tier::create([
                //         'customer_code'     => $line['CustomerCode'],
                //         'customer_name'    => $line['CustomerName'],
                //         'status_level' => $line['Status Level'],
                //         'pm_posm'    => $line['PM POSM'],
                //         'successful_lead'    => $line['Successful Lead'],
                //         'base_target_quarterly'    => $line['Base Target Quarter'],
                //         'base_target'    => $line['Base Target'],
                //         'last_update'  => $line['Last Update']
                //     ]);
                // });

                // (new FastExcel)->sheet(1)->import($path, function ($line) {

                //     return Gt_buy::create([
                //         'customer_code' => $line['CustomerCode'],
                //         'customer_name' => $line['CustomerName'],
                //         'base_target_month' => $line['Base Target Month'],
                //         'base_target' => $line['Base Target'],
                //         'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                //         'product_family_descr' => $line['ProductFamilyDescription'],
                //         'time_id' => $line['TimeId'],
                //         'ims' => $line['IMS'],
                //         'chain' => $line['Chain'],
                //     ]);
                // });

                // (new FastExcel)->sheet(2)->import($path, function ($line) {

                //     return Gt_tier::create([
                //         'customer_code'     => $line['CustomerCode'],
                //         'customer_name'    => $line['CustomerName'],
                //         'status_level' => $line['Status Level'],
                //         'pm_posm'    => $line['PM POSM'],
                //         'successful_lead'    => $line['Successful Lead'],
                //         'base_target_quarterly'    => $line['Base Target Quarter'],
                //         'base_target'    => $line['Base Target'],
                //         'last_update'  => $line['Last Update']
                //     ]);
                // });

                Session::flash('success', 'GT file uploaded!');

                DB::commit();
            } catch (QueryException $ex) {
                DB::rollback();
                Session::flash()->error('GT file failed! ' . $ex);
            }

            // $data = $request->session()->all();
            // print_r($data);
            // exit();
            return back();
        } else {
            $logPath = "";
            $host = request()->getHost();
            if (strstr($host, 'localhost') || strstr($host, '192.168')) {
                $csv_dir = '';
                $logPath = 'C:\wamp64\www\pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
                $upload_dir = '/home/gamestg/gamepmistg_export';
                $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games.pmisg.cloud.sg')) {
                $upload_dir = '/home/game/gamepmiprod_export';
                $logPath = '/home/game/public_html/pmi-backoffice/storage/gt/';
            }

            $log_date = Carbon::now()->format('Y-m-d');
            $log_name = 'GT-' . $log_date;
            $log = new Logger('GT-log');
            $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

            $filename = 'Data - GT.csv';

            try {

                $csvPath = $upload_dir . '/' . $filename;

                if (file_exists($csvPath)) {
                    GT::query()->truncate();
                    $result = Excel::import(new GTImport, $csvPath);

                    $allInvoiceData = GT::all();

                    // foreach ($allInvoiceData as $invoiceData) {

                    //     if (
                    //         !empty($invoiceData->invoice_date) and
                    //         $invoiceData->invoice_date != null and
                    //         $invoiceData->invoice_date != "0000-00-00"
                    //     ) {
                    //         $publishData = PhotoFeedbackInvoicesPublish::select("published_date")
                    //             ->where("cust_id", $invoiceData->cust_id)
                    //             ->get();

                    //         if ($publishData->isEmpty()) {

                    //             $invoicePublish = new PhotoFeedbackInvoicesPublish();
                    //             $invoicePublish->cust_id = $invoiceData->cust_id;
                    //             $invoicePublish->published_date =  $invoiceData->invoice_date;

                    //             $invoicePublish->save();
                    //         }
                    //     }
                    // }

                    $log->info($filename . ' imported successfully.');
                } else {
                    $log->warning($filename . ' imported failed. ' . $csvPath);
                }
            } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

                $log->warning($filename . '.csv imported failed. ' . $csvPath);
            }
        }
    }

    public function loyalty_dashboard(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;

                //$customerCode = substr($customerCodeMY, 5);
                $customerCode = substr($customerCodeMY, 2);

                //$currentYear = Carbon::now()->format("Y"); //202202
                //$currentMth = Carbon::now()->format("m"); //202202

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                $gtBuyData = Gt_buy::selectRaw("customer_code, base_target, SUM(ims) as total_ims, max(time_id) as time_id")
                    ->where("customer_code", $customerCode)
                    ->where('time_id', 'like',  $baseTargetMonth . '%')
                    ->groupBy('customer_code', 'base_target_month')
                    ->first();

                $gtTierData = Gt_tier::selectRaw("customer_code, status_level, base_target, pm_posm, successful_lead")
                    ->where("customer_code", $customerCode)
                    ->where('last_update', 'like',  $baseTargetMonth . '%')
                    ->first();

                if (($gtBuyData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'GT Buy Data not found.',
                    ), 200);
                }

                if (($gtTierData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'GT Tier Data not found.',
                    ), 200);
                }


                $timeIdYear = substr($gtBuyData->time_id, 0, 4);
                $timeIdMth = substr($gtBuyData->time_id, 4, -2);
                $timeIdDate = substr($gtBuyData->time_id, 6, 8);
                $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");
                $startOfQuarterDate = Carbon::now()->startOfQuarter()->format("d M");
                $endOfQuarterDate = Carbon::now()->endOfQuarter()->format("d M");

                $purchaseByDate = $startOfQuarterDate . " to " . $endOfQuarterDate;
                // $purchaseByDate = "";
                // switch (Carbon::now()->quarter) {
                //     case 1:
                //         $purchaseByDate = "31 March";
                //         break;
                //     case 2:
                //         $purchaseByDate = "30 June";
                //         break;
                //     case 3:
                //         $purchaseByDate = "30 September";
                //         break;
                //     case 4:
                //         $purchaseByDate = "31 December";
                //         break;
                // }


                $cartonNum = $this->carton;
                $baseTarget = (int)$gtBuyData->base_target / $cartonNum;
                $purchasedPacks = $gtBuyData->total_ims / $cartonNum;
                $quarterBaseTarget = $gtTierData->base_target / $cartonNum;
                $btg = (int)$quarterBaseTarget - (int)$purchasedPacks;

                $gtInfo = new \stdClass();
                $gtInfo->status_level = $gtTierData->status_level;
                $gtInfo->purchase_date = $purchaseDate;
                $gtInfo->purchase_by_date = $purchaseByDate;
                $gtInfo->base_target = $baseTarget;
                $gtInfo->purchased_packs = $purchasedPacks;
                $gtInfo->quarter_base_target = $quarterBaseTarget;
                $gtInfo->btg = $btg;
                $gtInfo->pm_posm = $gtTierData->pm_posm;
                $gtInfo->successful_lead = $gtTierData->successful_lead;

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'data' => $gtInfo,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }

    public function program_dashboard(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;

                //$customerCode = substr($customerCodeMY, 5);
                $customerCode = substr($customerCodeMY, 2);

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                $gtBuyData = Gt_buy::selectRaw("customer_code, base_target, SUM(ims) as total_ims, max(time_id) as time_id")
                    ->where("customer_code", $customerCode)
                    ->where('time_id', 'like',  $baseTargetMonth . '%')
                    ->groupBy('customer_code', 'base_target_month')
                    ->first();

                $gtTierData = Gt_tier::selectRaw("customer_code, status_level, base_target, pm_posm, successful_lead")
                    ->where("customer_code", $customerCode)
                    ->where('last_update', 'like',  $baseTargetMonth . '%')
                    ->first();


                if (($gtBuyData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'GT Buy Data not found.',
                    ), 200);
                }

                if (($gtTierData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'GT Tier Data not found.',
                    ), 200);
                }

                $timeIdYear = substr($gtBuyData->time_id, 0, 4);
                $timeIdMth = substr($gtBuyData->time_id, 4, -2);
                $timeIdDate = substr($gtBuyData->time_id, 6, 8);
                $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");
                $purchaseByDate = Carbon::now()->endOfQuarter()->format("d F");

                $cartonNum = $this->carton;

                $purchasedPacks = $gtBuyData->total_ims / $cartonNum;
                $baseTarget = (int)$gtBuyData->base_target / $cartonNum; // monthly base target
                $mthBaseTarget = $gtBuyData->base_target / $cartonNum;
                $btg = (int)$baseTarget - (int)$purchasedPacks;

                $startDate = Carbon::now(); //returns current day
                $firstDay = $startDate->firstOfMonth()->format("d M Y");
                $lastDay = $startDate->lastOfMonth()->format("d M Y");

                $currentMthYear = Carbon::now()->format('F Y'); // "01"

                $gtInfo = new \stdClass();
                $gtInfo->duration = $firstDay . " - " . $lastDay;
                $gtInfo->current_mth_year = $currentMthYear;
                //$gtInfo->status_level = $gtTierData->status_level;
                $gtInfo->purchase_date = $purchaseDate;
                //$gtInfo->purchase_by_date = $purchaseByDate;
                $gtInfo->total_target = $baseTarget; // Monthly Base Target
                $gtInfo->total_packs_sold = $purchasedPacks;
                $gtInfo->btg = $btg;

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'data' => $gtInfo,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }

    public function extract_attachments($connection, $message_number)
    {

        $attachments = array();

        $structure = imap_fetchstructure($connection, $message_number);

        if (isset($structure->parts) && count($structure->parts)) {

            for ($i = 0; $i < count($structure->parts); $i++) {

                $attachments[$i] = array(
                    'is_attachment' => false,
                    'filename' => '',
                    'name' => '',
                    'attachment' => ''
                );

                if ($structure->parts[$i]->ifdparameters) {
                    foreach ($structure->parts[$i]->dparameters as $object) {
                        if (strtolower($object->attribute) == 'filename') {
                            $attachments[$i]['is_attachment'] = true;
                            $attachments[$i]['filename'] = $object->value;
                        }
                    }
                }

                if ($structure->parts[$i]->ifparameters) {
                    foreach ($structure->parts[$i]->parameters as $object) {
                        if (strtolower($object->attribute) == 'name') {
                            $attachments[$i]['is_attachment'] = true;
                            $attachments[$i]['name'] = $object->value;
                        }
                    }
                }

                if ($attachments[$i]['is_attachment']) {
                    $attachments[$i]['attachment'] = imap_fetchbody($connection, $message_number, $i + 1);
                    if ($structure->parts[$i]->encoding == 3) { // 3 = BASE64
                        $attachments[$i]['attachment'] = base64_decode($attachments[$i]['attachment']);
                    } elseif ($structure->parts[$i]->encoding == 4) { // 4 = QUOTED-PRINTABLE
                        $attachments[$i]['attachment'] = quoted_printable_decode($attachments[$i]['attachment']);
                    }
                }
            }
        }

        return $attachments;
    }


    public function imap_test()
    {
        echo "Starting...";
        // $todayDate = Carbon::now()->format('j F Y');
        // echo $todayDate;

        // $imap = imap_open('{imap.gmail.com:993/imap/ssl}INBOX', 'pmi@onyxisland.com', 'onyx123!@', OP_READONLY);

        // $emailId   = imap_search($imap, 'FROM HanCheng.Tan@pmi.com SUBJECT "PMI-MY - Daily GT Dataset" ON "' . $todayDate . '"');
        // print_r($emailId);
        // $attachments = array();
        // if (!empty($emailId)) {
        //     $emailId = max($emailId);
        //     //$uids   = imap_search($imap, 'ALL', SE_UID);

        //     //$xlsxFile = imap_fetchbody($imap, $emailId, 2);
        //     $structure = imap_fetchstructure($imap, $emailId);
        //     if (isset($structure->parts) && count($structure->parts)) {

        //         for ($i = 0; $i < count($structure->parts); $i++) {

        //             $attachments[$i] = array(
        //                 'is_attachment' => false,
        //                 'filename' => '',
        //                 'name' => '',
        //                 'attachment' => ''
        //             );

        //             if ($structure->parts[$i]->ifdparameters) {
        //                 foreach ($structure->parts[$i]->dparameters as $object) {
        //                     if (strtolower($object->attribute) == 'filename') {
        //                         $attachments[$i]['is_attachment'] = true;
        //                         $attachments[$i]['filename'] = $object->value;
        //                     }
        //                 }
        //             }

        //             if ($structure->parts[$i]->ifparameters) {
        //                 foreach ($structure->parts[$i]->parameters as $object) {
        //                     if (strtolower($object->attribute) == 'name') {
        //                         $attachments[$i]['is_attachment'] = true;
        //                         $attachments[$i]['name'] = $object->value;
        //                     }
        //                 }
        //             }

        //             if ($attachments[$i]['is_attachment']) {
        //                 $attachments[$i]['attachment'] = imap_fetchbody($imap, $emailId, $i + 1);
        //                 if ($structure->parts[$i]->encoding == 3) { // 3 = BASE64
        //                     $attachments[$i]['attachment'] = base64_decode($attachments[$i]['attachment']);
        //                 } elseif ($structure->parts[$i]->encoding == 4) { // 4 = QUOTED-PRINTABLE
        //                     $attachments[$i]['attachment'] = quoted_printable_decode($attachments[$i]['attachment']);
        //                 }
        //             }
        //         }
        //     }
        // }

        // $fileName = $attachments[1]['filename'];


        // Storage::put($fileName, $attachments[1]['attachment']);
        // ob_end_clean();
        // exit();

        // $structure = imap_fetchstructure($imap, $emailId);
        // print_r($structure);

        // $client = Client::account('default');
        // $client->connect();

        // $folders = $client->getFolders();
        // // $folder = $client->getFolder('INBOX');
        // // $info = $folder->examine();

        // $messages = $folders->query()->get();
        // foreach ($messages as $message) {
        //     echo $message->getSubject() . '<br />';
        // }

        // exit();

        //Loop through every Mailbox
        /** @var \Webklex\PHPIMAP\Folder $folder */
        // foreach ($folders as $folder) {

        //     //Get all Messages of the current Mailbox $folder
        //     /** @var \Webklex\PHPIMAP\Support\MessageCollection $messages */
        //     $messages = $folder->messages()->all()->get();

        //     /** @var \Webklex\PHPIMAP\Message $message */
        //     foreach ($messages as $message) {
        //         echo $message->getSubject() . '<br />';
        //         echo 'Attachments: ' . $message->getAttachments()->count() . '<br />';
        //         //echo $message->getHTMLBody();

        //         //Move the current Message to 'INBOX.read'
        //         // if ($message->move('INBOX.read') == true) {
        //         //     echo 'Message has ben moved';
        //         // } else {
        //         //     echo 'Message could not be moved';
        //         // }

        //         if ($message->getSubject() == "Test") {
        //             echo "found~~~";
        //         }
        //     }
        // }
    }

    public function imap()
    {

        $gmail = new Gmail();

        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/gt-data/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/gt-data/';
        }

        $filterEmailArr = [
            'HanCheng.Tan@pmi.com',
            'ShahZulAmanShah.MuhammadHaziq@contracted.pmi.com',
            'Grace.Tan@pmi.com',
            'SiamsingiNaiker.PrasadBahadur@pmi.com',
            'samrong.tee@onyxisland.com'
        ];
        $filterEmailList = implode(" OR from:", $filterEmailArr);

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'GT-Data-' . $log_date;
        $log = new Logger('GT-data-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('');
        $log->info('Start search GT data from ' . $filterEmailList . '...');

        $todayDate = Carbon::now()->format('Y/m/d');

        try {

            ///////////Get refresh token

            $refreshToken = env('GOOGLE_REFRESH_TOKEN');
            $accessTokenResponse = $gmail->refreshToken($refreshToken);

            if ($accessTokenResponse->success === false) {
                $log->error('Filter latest mail: ' . $accessTokenResponse->response);
                throw new \ErrorException($accessTokenResponse->response);
            }
            $log->info('Access Token refreshed successfully.');
            $accessToken = $accessTokenResponse->response;
            $log->info('Access Token: ' . $accessToken);

            //$accessToken = "ya29.A0ARrdaM_3OsidtkRtkZpnxuF4U4MUaC9pJIdJhPrWxuLWr1Jg_xkJoHNJHsKGoyiUjWpWE66BXghojm2T6pcClVYy78kKyc2kVRhwuL4EJFM7443uWNDEdbfCUNQJMj-mJfUqmRR2bZgUlVxmm41AsLYGD-83Ew";
            ///////////Filter latest mail

            $latestEmail = $gmail->filterLatestMail($todayDate, $accessToken, $filterEmailList);
            if ($latestEmail->success === false) {
                $log->error('Filter latest mail: ' . $latestEmail->response->error->message);
                throw new \ErrorException($latestEmail->response->error->message);
            }

            if (empty($latestEmail->id)) {
                $log->info('Mail not found in the inbox. Please make sure the email send.');
                exit();
            }
            $log->info('Mail ID: ' . $latestEmail->id . ' retrieved.\n');

            ///////////Get Mail By ID

            $emailData = $gmail->getMailById($latestEmail->id, $accessToken);
            if ($emailData->success === false) {
                $log->error('Get Mail by ID: ' . $emailData->response->error->message);
                throw new \ErrorException($emailData->response->error->message);
            }
            $log->info('Received date: ' . $emailData->date . ' retrieved.');
            $log->info('Subject: ' . $emailData->subject . ' retrieved.');
            $log->info('From: ' . $emailData->from . ' retrieved.');
            $log->info('File name: ' . $emailData->filename . ' retrieved.');
            $log->info('Attachment ID: ' . $emailData->attachment_id . ' retrieved.');


            ///////////Get Attachment by ID

            $attachmentData = $gmail->getAttachmentId($latestEmail->id, $emailData->attachment_id, $emailData->filename, $accessToken);
            if ($attachmentData->success === false) {
                $log->error('Get attachment: ' . $attachmentData->response->error->message);
                throw new \ErrorException($attachmentData->response->error->message);
            }
            $log->info('Attachement: ' . $emailData->filename . ' read from API.');

            $decodedData = strtr($attachmentData->response, array('-' => '+', '_' => '/'));
            $decodedData = base64_decode($decodedData);

            $fileDate = Carbon::now()->format('Y-m-d his');
            $fileName = $fileDate . ' - ' . $emailData->filename;

            if (Storage::put('gt-files/' . $fileName, $decodedData)) {
                $log->info('Attachement: ' . $fileName . ' saved. Process completed.');
            } else {
                $log->error('File uploaded failed.');
            }

            /////////////// Start import data

            $log->info('Start importing GT data...');

            $path = storage_path('app/gt-files/' . $fileName);

            // insert file record
            $gtFile = new Gt_files;

            $gtFile->file_name = $fileName;
            $gtFile->path_name = $path;
            $gtFile->updated_at = null;
            $gtFile->save();

            Gt_buy::truncate();

            $BuyCollection = (new FastExcel)->sheet(1)->import($path);
            $BuyCollection->filter()->each(function ($line) {
                Gt_buy::create([
                    'customer_code' => $line['CustomerCode'],
                    'customer_name' => $line['CustomerName'],
                    'base_target_month' => $line['Base Target Month'],
                    'base_target' => $line['Base Target'],
                    'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                    'product_family_descr' => $line['ProductFamilyDescription'],
                    'time_id' => $line['TimeId'],
                    'ims' => $line['IMS'],
                    'chain' => $line['Chain']
                ]);
            });

            $tierCollection = (new FastExcel)->sheet(2)->import($path);

            if (count($tierCollection) > 0) {

                Gt_tier::truncate();

                $tierCollection->filter()->each(function ($line) {
                    Gt_tier::create([
                        'customer_code'     => $line['CustomerCode'],
                        'customer_name'    => $line['CustomerName'],
                        'status_level' => $line['Status Level'],
                        'pm_posm'    => $line['PM POSM'],
                        'successful_lead'    => $line['Successful Lead'],
                        'base_target_quarterly'    => $line['Base Target Quarter'],
                        'base_target'    => $line['Base Target'],
                        'last_update'  => $line['Last Update']
                    ]);
                });
            }

            $log->info('GT data imported successfully.');
        } catch (QueryException $ex) {
            $log->error('Gmail sync failed.' . $ex);
        }
    }
}
