<?php

namespace App\Http\Controllers;

use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Ka_files;
use App\Models\Ka_data;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Response;

use Rap2hpoutre\FastExcel\FastExcel;

class KaController extends Controller
{
    public $carton = 20;

    public function importView()
    {
        return view('ka.import');
    }

    public function index()
    {

        if (request()->ajax()) {
            $gt = DB::connection('mysql')
                ->table('ka_files')
                ->select(['id', 'file_name', 'created_at'])
                ->orderByDesc('created_at');

            return datatables()->of($gt)
                ->addColumn('download', function ($row) {
                    if (auth()->user()->can('import loyalty')) {
                        return "<a href='" . url("api/download-ka-files/" . $row->id) . "' class='btn btn-default'>Download</a>";
                    }
                })
                ->rawColumns(['download'])
                ->make(true);
        }

        return view('gt.import');
    }

    public function download_ka_file($fileId)
    {

        $filesInfo = Ka_files::find($fileId);

        $path = storage_path() . '/' . 'app' . '/ka-files/' . $filesInfo->file_name;
        if (file_exists($path)) {
            ob_end_clean(); // this
            ob_start();
            return Response::download($path);
        }
    }

    public function import(Request $request)
    {

        //ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ini_set('mysql.connect_timeout', '0');
        ini_set('max_execution_time', '0');
        ini_set('default_socket_timeout', 9000);

        if ($request->hasFile('file')) {

            DB::beginTransaction();

            try {

                $fileOriginName = $request->file('file')->getClientOriginalName();
                $saveFileName = Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;

                $path = $request->file('file')->storeAs(
                    'ka-files',
                    $saveFileName
                );

                $path = storage_path('app/' . $path);

                $kaFile = new Ka_files;

                $kaFile->file_name = $saveFileName;
                $kaFile->path_name = $path;
                $kaFile->updated_at = null;
                $kaFile->save();

                //->withoutHeaders()
                // $kaCollection = (new FastExcel)->sheet(1)->import($path);
                // $kaCollection->filter()->each(function ($line, $countRow = 0) {


                //     //if ($countRow <= 2) {

                //     Ka_data::create([
                //         'program_start_date' => $line['Program Start Date'],
                //         'program_end_date' => $line['Program End Date'],
                //         'store_id' => $line['Store ID'],
                //         'chain' => $line['Chain'],
                //         'cust_code' => $line['Cust. Code'],
                //         'store_name' => $line['Store Name'],
                //         'total_pmm_program_available' => $line['Total PMM Program Available'],
                //         'total_pmm_target_available' => $line['Total PMM Target Available'],
                //         'total_pmm_target' => $line['Total PMM Target '],
                //         'total_pmm_offtake_achievement' => $line['Total PMM Offtake Achievement'],
                //         'total_pmm_btg' => $line['Total PMM BTG '],
                //         'focus_brand_program_available' => $line['Focus Brand program Available'],
                //         'focus_brand' => $line['Focus Brand'],
                //         'focus_brand_target' => $line['Focus Brand Target'],
                //         'total_focus_brand_target' => $line['Total Focus Brand Target'],
                //         'total_focus_brand_offtake_achievement' => $line['Total Focus Brand Offtake Achievement'],
                //         'total_focus_brand_btg' => $line['Total Focus Brand BTG '],
                //         'focus_brand_reward_per_pack_rm' => $line['Focus Brand Reward per pack (RM)'],
                //         'focus_brand_rewards_rm' => $line['Focus Brand Rewards (RM)'],
                //         'last_update' => $line['Last Update']
                //     ]);
                //     //}

                //     $countRow++;
                // });


                Session::flash('success', 'KA file uploaded!');

                DB::commit();
            } catch (QueryException $ex) {
                DB::rollback();
                Session::flash()->error('KA file failed! ' . $ex);
            }

            return back();
        } else {
            $logPath = "";
            $host = request()->getHost();
            if (strstr($host, 'localhost') || strstr($host, '192.168')) {
                $csv_dir = '';
                $logPath = 'C:\wamp64\www\pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
                $upload_dir = '/home/gamestg/gamepmistg_export';
                $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games.pmisg.cloud.sg')) {
                $upload_dir = '/home/game/gamepmiprod_export';
                $logPath = '/home/game/public_html/pmi-backoffice/storage/gt/';
            }

            $log_date = Carbon::now()->format('Y-m-d');
            $log_name = 'GT-' . $log_date;
            $log = new Logger('GT-log');
            $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

            $filename = 'Data - KA.csv';

            try {

                $csvPath = $upload_dir . '/' . $filename;

                if (file_exists($csvPath)) {
                    GT::query()->truncate();
                    $result = Excel::import(new GTImport, $csvPath);

                    $allInvoiceData = GT::all();

                    // foreach ($allInvoiceData as $invoiceData) {

                    //     if (
                    //         !empty($invoiceData->invoice_date) and
                    //         $invoiceData->invoice_date != null and
                    //         $invoiceData->invoice_date != "0000-00-00"
                    //     ) {
                    //         $publishData = PhotoFeedbackInvoicesPublish::select("published_date")
                    //             ->where("cust_id", $invoiceData->cust_id)
                    //             ->get();

                    //         if ($publishData->isEmpty()) {

                    //             $invoicePublish = new PhotoFeedbackInvoicesPublish();
                    //             $invoicePublish->cust_id = $invoiceData->cust_id;
                    //             $invoicePublish->published_date =  $invoiceData->invoice_date;

                    //             $invoicePublish->save();
                    //         }
                    //     }
                    // }

                    $log->info($filename . ' imported successfully.');
                } else {
                    $log->warning($filename . ' imported failed. ' . $csvPath);
                }
            } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

                $log->warning($filename . '.csv imported failed. ' . $csvPath);
            }
        }
    }


    // public function program_dashboard(Request $request)
    // {
    //     if ($request->all()) {
    //         if (
    //             $request->has("query")
    //         ) {

    //             $query = $request->input('query');
    //             $dte = new DTEdecode();
    //             $decryptedData = $dte->decode_id($query, FALSE);
    //             if ($decryptedData == false) {

    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'Invalid query string. ',
    //                 ), 200);
    //             }

    //             $dteUser = $decryptedData->User;
    //             $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;

    //             //$customerCode = substr($customerCodeMY, 5);
    //             $customerCode = substr($customerCodeMY, 2);

    //             $baseTargetMonth = Carbon::now()->format("Ym"); //202202

    //             $kaData = Ka_data::selectRaw("total_pmm_target, total_pmm_offtake_achievement, total_pmm_btg, max(last_update) as last_update")
    //                 ->where("cust_code", $customerCode)
    //                 ->where('last_update', 'like',  $baseTargetMonth . '%')
    //                 ->first();


    //             if (($kaData === null)) {
    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'KA Data not found.',
    //                 ), 200);
    //             }

    //             $timeIdYear = substr($kaData->last_update, 0, 4);
    //             $timeIdMth = substr($kaData->last_update, 4, -2);
    //             $timeIdDate = substr($kaData->last_update, 6, 8);
    //             $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

    //             if (($kaData->last_update === null)) {
    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'KA Data not found.',
    //                 ), 200);
    //             }

    //             $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");


    //             $totalTarget = (int)$kaData->total_pmm_target;
    //             $totalPacksSold = (int) $kaData->total_pmm_offtake_achievement;
    //             $btg = (int)$kaData->total_pmm_btg;

    //             $startDate = Carbon::now(); //returns current day
    //             $firstDay = $startDate->firstOfMonth()->format("d M Y");
    //             $lastDay = $startDate->lastOfMonth()->format("d M Y");

    //             $currentMthYear = Carbon::now()->format('F Y'); // "01"

    //             $kaInfo = new \stdClass();
    //             $kaInfo->duration = $firstDay . " - " . $lastDay;
    //             $kaInfo->current_mth_year = $currentMthYear;
    //             $kaInfo->purchase_date = $purchaseDate;
    //             $kaInfo->total_target = $totalTarget; // Monthly Base Target
    //             $kaInfo->total_packs_sold = $totalPacksSold;
    //             $kaInfo->btg = $btg;

    //             return response()->json(array(
    //                 'success' => true,
    //                 'message' => 'Success.',
    //                 'data' => $kaInfo,
    //                 'dte_data' => $decryptedData
    //             ), 200);
    //         } else {
    //             return response()->json(['status' => false, 'message' => "Query not found."], 500);
    //         }
    //     } else {
    //         return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
    //     }
    // }

    // public function focus_dashboard(Request $request)
    // {
    //     if ($request->all()) {
    //         if (
    //             $request->has("query")
    //         ) {

    //             $query = $request->input('query');
    //             $dte = new DTEdecode();
    //             $decryptedData = $dte->decode_id($query, FALSE);
    //             if ($decryptedData == false) {

    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'Invalid query string. ',
    //                 ), 200);
    //             }

    //             $dteUser = $decryptedData->User;
    //             $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;

    //             $customerCode = substr($customerCodeMY, 2);

    //             $baseTargetMonth = Carbon::now()->format("Ym"); //202202

    //             $kaData = Ka_data::selectRaw("total_focus_brand_offtake_achievement, focus_brand_rewards_rm, max(last_update) as last_update")
    //                 ->where("cust_code", $customerCode)
    //                 ->where('last_update', 'like',  $baseTargetMonth . '%')
    //                 ->first();


    //             if (($kaData === null)) {
    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'KA Data not found.',
    //                 ), 200);
    //             }

    //             $timeIdYear = substr($kaData->last_update, 0, 4);
    //             $timeIdMth = substr($kaData->last_update, 4, -2);
    //             $timeIdDate = substr($kaData->last_update, 6, 8);

    //             if (($kaData->last_update === null)) {
    //                 return response()->json(array(
    //                     'success' => false,
    //                     'message' => 'KA Data not found.',
    //                 ), 200);
    //             }

    //             $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

    //             $dateAsOf = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");

    //             $achievement = (int)$kaData->focus_brand_rewards_rm;
    //             $totalPacksSold = (int) $kaData->total_focus_brand_offtake_achievement;

    //             $kaFocus = new \stdClass();
    //             $kaFocus->achievement = $achievement;
    //             $kaFocus->total_packs_sold = $totalPacksSold;
    //             $kaFocus->date_as_of = $dateAsOf;

    //             return response()->json(array(
    //                 'success' => true,
    //                 'message' => 'Success.',
    //                 'data' => $kaFocus,
    //                 'dte_data' => $decryptedData
    //             ), 200);
    //         } else {
    //             return response()->json(['status' => false, 'message' => "Query not found."], 500);
    //         }
    //     } else {
    //         return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
    //     }
    // }
}
