<?php

namespace App\Http\Controllers;

//use App\Doc;
use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Gt_buy;
use App\Models\Gt_tier;
use App\Models\GtPastIncentive;
use App\Models\Ka_data;
use App\Models\Lead_data;
use Illuminate\Support\Carbon;


class Dashboard2022 extends Controller
{
    public $carton = 20;
    public $gtChain = "GT";
    public $kaChain = "KA";

    public function loyalty_dashboard(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
                $chain = $dteUser->Contact->Account->DTE_Chain__c;

                $customerCode = substr($customerCodeMY, 2);

                // if ($customerCode != "61100000003") { //if test account then skip
                //     if ($chain != $this->gtChain or $chain != $this->gtChain) {
                //         return response()->json(array(
                //             'success' => false,
                //             'message' => 'Invalid chain. ',
                //         ), 200);
                //     }
                // }

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                //$currentYear = Carbon::now()->format("Y"); //202202
                //$currentMth = Carbon::now()->format("m"); //202202

                $gtBuyLatestDate = Gt_buy::selectRaw("created_at")
                    ->where("customer_code", $customerCode)
                    ->orderBy("created_at", "desc")
                    ->first();

                if (($gtBuyLatestDate === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Please come back after 15 - 30 mins',
                        'message_code' => 'GT Buy Data not found.',
                    ), 200);
                }

                $gtBuyLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $gtBuyLatestDate->created_at)->format("Y-m-d");

                $gtBuyData = Gt_buy::selectRaw("customer_code, base_target, SUM(ims) as total_ims, max(time_id) as time_id")
                    ->where("customer_code", $customerCode)
                    //->where('time_id', 'like',  $baseTargetMonth . '%')
                    ->whereDate('created_at', $gtBuyLatestDate)
                    ->groupBy('customer_code', 'base_target_month')
                    ->first();

                $gtTierLatestDate = Gt_tier::selectRaw("created_at")
                    ->where("customer_code", $customerCode)
                    ->orderBy("created_at", "desc")
                    ->first();

                $gtTierLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $gtTierLatestDate->created_at)->format("Y-m-d");

                $gtTierData = Gt_tier::selectRaw("customer_code, status_level, base_target, pm_posm, successful_lead")
                    ->where("customer_code", $customerCode)
                    ->whereDate('created_at', $gtTierLatestDate)
                    //->where('last_update', 'like',  $baseTargetMonth . '%')
                    ->first();

                if (($gtBuyData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Please come back after 15 - 30 mins',
                        'message_code' => 'GT Buy Data not found.',
                    ), 200);
                }

                if (($gtTierData === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Please come back after 15 - 30 mins',
                        'message_code' => 'GT Tier Data not found.',
                    ), 200);
                }


                $timeIdYear = substr($gtBuyData->time_id, 0, 4);
                $timeIdMth = substr($gtBuyData->time_id, 4, -2);
                $timeIdDate = substr($gtBuyData->time_id, 6, 8);
                $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");

                $startOfQuarterDate = Carbon::now()->startOfQuarter()->format("d M");
                $endOfQuarterDate = Carbon::now()->endOfQuarter()->format("d M");
                $startOfQuarterDate = ($startOfQuarterDate == "01 Jan") ? "01 Mar" : $startOfQuarterDate;
                $purchaseByDate = "from " . $startOfQuarterDate . " to " . $endOfQuarterDate;
                // $purchaseByDate = "";
                // switch (Carbon::now()->quarter) {
                //     case 1:
                //         $purchaseByDate = "31 March";
                //         break;
                //     case 2:
                //         $purchaseByDate = "30 June";
                //         break;
                //     case 3:
                //         $purchaseByDate = "30 September";
                //         break;
                //     case 4:
                //         $purchaseByDate = "31 December";
                //         break;
                // }


                $cartonNum = $this->carton;
                $baseTarget = (int)$gtBuyData->base_target / $cartonNum;
                $purchasedPacks = $gtBuyData->total_ims / $cartonNum;
                $quarterBaseTarget = $gtTierData->base_target / $cartonNum;
                $btg = (int)$quarterBaseTarget - (int)$purchasedPacks;

                $gtInfo = new \stdClass();
                $gtInfo->status_level = $gtTierData->status_level;
                $gtInfo->purchase_date = $purchaseDate;
                $gtInfo->purchase_by_date = $purchaseByDate;
                $gtInfo->base_target = $baseTarget;
                $gtInfo->purchased_packs = $purchasedPacks;
                $gtInfo->quarter_base_target = $quarterBaseTarget;
                $gtInfo->btg = $btg;
                $gtInfo->pm_posm = $gtTierData->pm_posm;
                $gtInfo->successful_lead = $gtTierData->successful_lead;

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'data' => $gtInfo,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }

    public function program_dashboard(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
                //$chain = $dteUser->Contact->Account->DTE_Chain__c;

                //$customerCode = substr($customerCodeMY, 5);
                $customerCode = substr($customerCodeMY, 2);

                // if ($customerCode != "61100000003") { //if test account then skip
                //     if ($chain != $this->gtChain or $chain != $this->gtChain) {
                //         return response()->json(array(
                //             'success' => false,
                //             'message' => 'Invalid chain. ',
                //         ), 200);
                //     }
                // } else {
                //     $chain = "KA"; // GTRETLG or KA testing purpose !!!
                // }

                $gtData = Gt_buy::where("customer_code", $customerCode)->first();

                $audience = "";
                if (!empty($gtData)) {
                    $audience =  $this->gtChain;
                } else {
                    $audience =  $this->kaChain;
                }

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                switch ($audience) {
                    case $this->gtChain: ////////// GT audience

                        $gtBuyLatestDate = Gt_buy::selectRaw("created_at")
                            ->where("customer_code", $customerCode)
                            ->orderBy("created_at", "desc")
                            ->first();

                        $gtBuyLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $gtBuyLatestDate->created_at)->format("Y-m-d");

                        $gtBuyData = Gt_buy::selectRaw("customer_code, base_target, SUM(ims) as total_ims, max(time_id) as time_id")
                            ->where("customer_code", $customerCode)
                            ->whereDate("created_at", $gtBuyLatestDate)
                            //->where('time_id', 'like',  $baseTargetMonth . '%')
                            ->groupBy('customer_code', 'base_target_month')
                            ->first();

                        $gtTierLatestDate = Gt_tier::selectRaw("created_at")
                            ->where("customer_code", $customerCode)
                            ->orderBy("created_at", "desc")
                            ->first();

                        $gtTierLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $gtTierLatestDate->created_at)->format("Y-m-d");

                        $gtTierData = Gt_tier::selectRaw("customer_code, status_level, base_target, pm_posm, successful_lead")
                            ->where("customer_code", $customerCode)
                            ->whereDate("created_at", $gtTierLatestDate)
                            //->where('last_update', 'like',  $baseTargetMonth . '%')
                            ->first();


                        if (($gtBuyData === null)) {
                            return response()->json(array(
                                'success' => false,
                                'message' => 'Please come back after 15 - 30 mins',
                                'message_code' => 'GT Buy Data not found.',
                            ), 200);
                        }

                        if (($gtTierData === null)) {
                            return response()->json(array(
                                'success' => false,
                                'message' => 'Please come back after 15 - 30 mins',
                                'message_code' => 'GT Tier Data not found.',
                            ), 200);
                        }

                        $timeIdYear = substr($gtBuyData->time_id, 0, 4);
                        $timeIdMth = substr($gtBuyData->time_id, 4, -2);
                        $timeIdDate = substr($gtBuyData->time_id, 6, 8);
                        $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                        $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");
                        $purchaseByDate = Carbon::now()->endOfQuarter()->format("d F");

                        $cartonNum = $this->carton;

                        $purchasedPacks = $gtBuyData->total_ims / $cartonNum;
                        $baseTarget = (int)$gtBuyData->base_target / $cartonNum; // monthly base target
                        $mthBaseTarget = $gtBuyData->base_target / $cartonNum;
                        $btg = (int)$baseTarget - (int)$purchasedPacks;

                        $startDate = Carbon::now(); //returns current day
                        $firstDay = $startDate->firstOfMonth()->format("d M Y");
                        $lastDay = $startDate->lastOfMonth()->format("d M Y");

                        $currentMthYear = Carbon::now()->format('F Y'); // "01"

                        $gtInfo = new \stdClass();
                        $gtInfo->duration = $firstDay . " - " . $lastDay;
                        $gtInfo->current_mth_year = $currentMthYear;
                        //$gtInfo->status_level = $gtTierData->status_level;
                        $gtInfo->purchase_date = $purchaseDate;
                        //$gtInfo->purchase_by_date = $purchaseByDate;
                        $gtInfo->total_target = $baseTarget; // Monthly Base Target
                        $gtInfo->total_packs_sold = $purchasedPacks;
                        $gtInfo->btg = $btg;

                        return response()->json(array(
                            'success' => true,
                            'message' => 'Success.',
                            'audience' => $audience,
                            'data' => $gtInfo,
                            'dte_data' => $decryptedData
                        ), 200);

                        break;

                    case $this->kaChain: ////////// KA audience

                        $kaDataLatestDate = Ka_data::selectRaw("created_at")
                            ->where("cust_code", $customerCode)
                            ->orderBy("created_at", "desc")
                            ->first();

                        if (empty($kaDataLatestDate)) {
                            return response()->json(array(
                                'success' => false,
                                'message' => 'Please come back after 15 - 30 mins',
                                'message_code' => 'GT/KA Data not found.',
                            ), 200);
                        }

                        $kaDataLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $kaDataLatestDate->created_at)->format("Y-m-d");

                        $kaData = Ka_data::selectRaw("total_pmm_target, total_pmm_offtake_achievement, total_pmm_btg, max(last_update) as last_update")
                            ->where("cust_code", $customerCode)
                            ->whereDate('created_at', $kaDataLatestDate)
                            //->where('last_update', 'like',  $baseTargetMonth . '%')
                            ->first();


                        if (($kaData === null)) {
                            return response()->json(array(
                                'success' => false,
                                'message' => 'Please come back after 15 - 30 mins',
                                'message_code' => 'KA Data not found.',
                            ), 200);
                        }

                        $timeIdYear = substr($kaData->last_update, 0, 4);
                        $timeIdMth = substr($kaData->last_update, 4, -2);
                        $timeIdDate = substr($kaData->last_update, 6, 8);
                        $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                        if (($kaData->last_update === null)) {
                            return response()->json(array(
                                'success' => false,
                                'message' => 'Please come back after 15 - 30 mins',
                                'message_code' => 'KA Data not found.',
                            ), 200);
                        }

                        $purchaseDate = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");


                        $totalTarget = (int)$kaData->total_pmm_target;
                        $totalPacksSold = (int) $kaData->total_pmm_offtake_achievement;
                        $btg = (int)$kaData->total_pmm_btg;

                        $startDate = Carbon::now(); //returns current day
                        $firstDay = $startDate->firstOfMonth()->format("d M Y");
                        $lastDay = $startDate->lastOfMonth()->format("d M Y");

                        $currentMthYear = Carbon::now()->format('F Y'); // "01"

                        $kaInfo = new \stdClass();
                        $kaInfo->duration = $firstDay . " - " . $lastDay;
                        $kaInfo->current_mth_year = $currentMthYear;
                        $kaInfo->purchase_date = $purchaseDate;
                        $kaInfo->total_target = $totalTarget; // Monthly Base Target
                        $kaInfo->total_packs_sold = $totalPacksSold;
                        $kaInfo->btg = $btg;

                        return response()->json(array(
                            'success' => true,
                            'message' => 'Success.',
                            'audience' => $audience,
                            'data' => $kaInfo,
                            'dte_data' => $decryptedData
                        ), 200);
                        break;
                }
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }


    public function focus_dashboard(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;

                $customerCode = substr($customerCodeMY, 2);

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                $kaDataLatestDate = Ka_data::selectRaw("created_at")
                    ->where("cust_code", $customerCode)
                    ->orderBy("created_at", "desc")
                    ->first();

                if (($kaDataLatestDate === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Please come back after 15 - 30 mins',
                        'message_code' => 'KA Data not found.',
                    ), 200);
                }

                $kaDataLatestDate = Carbon::createFromFormat('Y-m-d H:i:s', $kaDataLatestDate->created_at)->format("Y-m-d");

                $kaData = Ka_data::selectRaw("total_focus_brand_offtake_achievement, focus_brand_rewards_rm, max(last_update) as last_update")
                    ->where("cust_code", $customerCode)
                    ->whereDate('created_at', $kaDataLatestDate)
                    //->where('last_update', 'like',  $baseTargetMonth . '%')
                    ->first();


                $timeIdYear = substr($kaData->last_update, 0, 4);
                $timeIdMth = substr($kaData->last_update, 4, -2);
                $timeIdDate = substr($kaData->last_update, 6, 8);

                if (($kaData->last_update === null)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Please come back after 15 - 30 mins',
                        'message_code' => 'KA Data not found.',
                    ), 200);
                }

                $latestTimeId = $timeIdYear . "-" . $timeIdMth . "-" . $timeIdDate;

                $dateAsOf = Carbon::createFromFormat('Y-m-d', $latestTimeId)->format("d F Y");

                $achievement = (int)$kaData->focus_brand_rewards_rm;
                $totalPacksSold = (int) $kaData->total_focus_brand_offtake_achievement;

                $kaFocus = new \stdClass();
                $kaFocus->achievement = $achievement;
                $kaFocus->total_packs_sold = $totalPacksSold;
                $kaFocus->date_as_of = $dateAsOf;

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'data' => $kaFocus,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }

    public function lead_history(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');

                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $custCode = $dteUser->Contact->Account->DTE_AccountNumber__c;
                $email = $dteUser->Email;
                // $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
                // $customerCode = substr($customerCodeMY, 2);

                $baseTargetMonth = Carbon::now()->format("Ym"); //202202

                $allLeadData = Lead_data::selectRaw("id")
                    ->where("account_number", $custCode)
                    ->where("retailer_email", $email)
                    //->where('last_update', 'like',  $baseTargetMonth . '%')
                    ->get();

                if (($allLeadData === null)) {

                    // return response()->json(array(
                    //     'success' => false,
                    //     'message' => 'Lead Data not found.',
                    // ), 200);

                    $leadData = new \stdClass();
                    $leadData->total_created_leads = 0;
                    $leadData->total_purchased_leads = 0;
                    $leadData->total_newsly_created = 0;
                    $leadData->percentage = 0;

                    return response()->json(array(
                        'success' => true,
                        'message' => 'Success.',
                        'data' => $leadData,
                        'dte_data' => $decryptedData
                    ), 200);
                }

                $purchasedLeadData = Lead_data::selectRaw("id")
                    ->where("account_number", $custCode)
                    ->where("retailer_email", $email)
                    ->where('stage', 'like',  '%Purchased%')
                    ->get();

                $totalCreatedLeads = $allLeadData->count();
                $totalPurchasedData = $purchasedLeadData->count();
                $totalNewlyCreated = $totalCreatedLeads - $totalPurchasedData;

                $nonSuccessData = Lead_data::selectRaw("name, email, mobile, created_date, stage")
                    ->where("account_number", $custCode)
                    ->where("retailer_email", $email)
                    ->where('stage', 'not like',  '%Purchased%')
                    ->orderBy('created_date', 'desc')
                    ->get();
                //->paginate(2);

                $leadData = new \stdClass();
                $leadData->total_created_leads = $totalCreatedLeads;
                $leadData->total_purchased_leads = $totalPurchasedData;
                $leadData->total_newsly_created = $totalNewlyCreated;
                $leadData->percentage = ($totalCreatedLeads > 0) ? round(($totalPurchasedData / $totalCreatedLeads) * 100) : 0;
                $leadData->lead_list = $nonSuccessData;

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'data' => $leadData,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }

    public function gt_past_incentive(Request $request)
    {
        if ($request->all()) {
            if (
                $request->has("query")
            ) {

                $query = $request->input('query');
                $year = $request->input('year');
                $defaultView = $request->input('default_view');

                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, FALSE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                $dteUser = $decryptedData->User;
                $custCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
                $email = $dteUser->Email;

                $custCode = substr($custCodeMY, 2);

                $currentYear = Carbon::now()->format("Y"); //2022

                if ($currentYear == $year) {
                    $endBaseTargetMonth = $year . Carbon::now()->format("m"); // if current year then need to remove current month data
                } else {
                    $endBaseTargetMonth = $year . '13';
                }
                $currentBaseTargetMonth = Carbon::now()->format("Ym"); //202203

                // retrieve year dropdown
                $distinctYearMonthData = GtPastIncentive::select('base_target_month')->distinct()
                    ->where('base_target_month', '!=', $currentBaseTargetMonth)
                    ->orderBy('base_target_month', 'asc')->get();

                $yearArr = [];
                foreach ($distinctYearMonthData as $distinctYearMonth) {
                    $baseTargetYear = (int)substr($distinctYearMonth->base_target_month, 0, 4);

                    //$yearArr[$baseTargetYear] = $baseTargetYear;
                    if (!in_array($baseTargetYear, $yearArr)) {
                        array_push($yearArr, $baseTargetYear);
                    }
                }

                $yearDropdownArr = [];
                foreach ($yearArr as $yearVal) {
                    if (!in_array($yearVal, $yearDropdownArr)) {
                        array_push($yearDropdownArr, $yearVal);
                    }
                }

                if ($year === "") {
                    $gtPastData = GtPastIncentive::where('customer_code', $custCode)
                        ->get();
                } else {

                    //$leadingZeroMonth = sprintf("%02d", $month);

                    // Dynamic where query
                    $gtPastDataQuery = GtPastIncentive::query();
                    $gtPastDataQuery->where('customer_code', $custCode);

                    if ($defaultView == true) {
                        $gtPastDataQuery->where('base_target_month', '>', ($year - 1) . '00') // need to put out the last year of the selected year data
                            ->where('base_target_month', '<', $endBaseTargetMonth);
                    } else {
                        $gtPastDataQuery->where('base_target_month', 'like', $year . '%')
                            ->where('base_target_month', '<', $endBaseTargetMonth);
                    }

                    //$gtPastDataQuery->where('base_target_month', 'like', '%' . $month)->get();
                    $gtPastData = $gtPastDataQuery->get();
                }

                // if ((count($gtPastData) <= 0)) {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => 'Please come back after 15 - 30 mins',
                //         'message_code' => 'GT Past Incentive data not found.',
                //     ), 200);
                // }

                $gtPastDataArr = [];

                foreach ($gtPastData as $ix => $gtPast) {

                    $baseTargetYear = (int)substr($gtPast->base_target_month, 0, 4);
                    $baseTargetMth = (int)substr($gtPast->base_target_month, 4, 2);

                    $target = ($gtPast->base_target > 0) ? $gtPast->base_target / 20 : $gtPast->base_target;
                    $purchased = ($gtPast->ims > 0) ? $gtPast->ims / 20 : $gtPast->ims;
                    $buyEnough = $gtPast->buy_enough_rebate;
                    $buyAbove = $gtPast->buy_above_rebate;
                    $total = $gtPast->total_rebate;

                    if (empty($gtPastDataArr[$baseTargetYear])) {
                        $gtPastDataArr[$baseTargetYear] = [];
                    }

                    // Carbon bug issue !!!
                    $monthName = ($baseTargetMth == '02') ? "Feb" : Carbon::createFromFormat('m', $baseTargetMth)->format('M');

                    $dataArr = [];
                    $dataArr['year'] = $baseTargetYear;
                    $dataArr['month'] = $monthName;
                    $dataArr['target'] = $target;
                    $dataArr['purchased'] = $purchased;
                    $dataArr['buy_enough'] = number_format($buyEnough, 1);
                    $dataArr['buy_above'] = number_format($buyAbove, 1);
                    $dataArr['total'] = number_format($total, 1);
                    array_push($gtPastDataArr[$baseTargetYear], $dataArr);
                }

                // reformat the array for pass to the front end 
                $yearSeparateArr = [];
                foreach ($yearDropdownArr as $year) {
                    array_push($yearSeparateArr, ["year" => $year, "data" => []]);
                }

                foreach ($gtPastDataArr as $gtPastDataYearIx =>  $gtPastData) {
                    foreach ($yearSeparateArr as &$yearSeparateVal) {
                        if ($yearSeparateVal['year'] == $gtPastDataYearIx) {
                            $yearSeparateVal['data'] = $gtPastData;
                        }
                    }
                }

                return response()->json(array(
                    'success' => true,
                    'message' => 'Success.',
                    'current_year' => (int)$currentYear,
                    'year_dropdown' => $yearDropdownArr,
                    'data' => $yearSeparateArr,
                    'dte_data' => $decryptedData
                ), 200);
            } else {
                return response()->json(['status' => false, 'message' => "Query not found."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
        }
    }
}
