<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function sendResetLinkFailedResponse(Request $request, $response)
    {
        /*
        return back()->withErrors(
            ['email' => trans($response)]
        )->withInput($request->only('email'));
        */
        return $this->sendResetLinkResponse($request, $response);
    }

    protected function validateEmail(Request $request)
    {
        $this->validate(
            $request,
            [
                'email' => 'required|email'
            ],
            [
                'email.email' => '<Your custom email error message>',
                'email.required' => '<Your custom email error message>'
            ]
        );
    }
}
