<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Ka_data;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;


use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ImportKA extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:importKA';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import KA';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/ka-data/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/ka-data/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'KA-Data-' . $log_date;
        $log = new Logger('KA-data-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('Start importing KA data...');

        //\Log::info("Cron is working fine!");
        //$this->info('KA Cron Cummand Run successfully!');

        try {

            $files = scandir('/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/app/ka-files', SCANDIR_SORT_DESCENDING);
            $newest_file = $files[0];

            $path = storage_path('app/ka-files/' . $newest_file);

            Ka_data::truncate();

            $kaCollection = (new FastExcel)->import($path);
            $kaCollection->filter()->each(function ($line, $countRow = 0) {

                Ka_data::create([
                    'program_start_date' => $line['Program Start Date'],
                    'program_end_date' => $line['Program End Date'],
                    'store_id' => $line['Store ID'],
                    'chain' => $line['Chain'],
                    'cust_code' => $line['Cust. Code'],
                    'store_name' => $line['Store Name'],
                    'total_pmm_program_available' => $line['Total PMM Program Available'],
                    'total_pmm_target_available' => $line['Total PMM Target Available'],
                    'total_pmm_target' => $line['Total PMM Target '],
                    'total_pmm_offtake_achievement' => $line['Total PMM Offtake Achievement'],
                    'total_pmm_btg' => $line['Total PMM BTG '],
                    'focus_brand_program_available' => $line['Focus Brand program Available'],
                    'focus_brand' => $line['Focus Brand'],
                    'focus_brand_target' => $line['Focus Brand Target'],
                    'total_focus_brand_target' => $line['Total Focus Brand Target'],
                    'total_focus_brand_offtake_achievement' => $line['Total Focus Brand Offtake Achievement'],
                    'total_focus_brand_btg' => $line['Total Focus Brand BTG '],
                    'focus_brand_reward_per_pack_rm' => $line['Focus Brand Reward per pack (RM)'],
                    'focus_brand_rewards_rm' => $line['Focus Brand Rewards (RM)'],
                    'last_update' => $line['Last Update']
                ]);

                $countRow++;
            });

            $log->info('KA data imported successfully.');
        } catch (\Exception $ex) {
            $log->critical('KA data imported failed.' . $ex);
        }
    }
}
