<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use App\BalanceTaking;
use App\Payout;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Mail;
use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\DB;
use App\Helpers\SMSDome;

class BalanceTakingEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:balance_taking_email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command Send Email (Balance Taking)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        // $knownDate = Carbon::create(2021, 10, 17, 12);
        // Carbon::setTestNow($knownDate);

        $host = request()->getHost();

        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/balance-taking/email/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/balance-taking/email/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/balance-taking/email/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Balance-taking-Email-' . $log_date;
        $log = new Logger('Balance-taking-Email-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $today = new Carbon();
        $dayOfWeek = $today->dayOfWeek;

        // today submitted data
        $btData = BalanceTaking::whereDate('created_at', Carbon::today())
            ->leftJoin('qa_payout', 'qa_payout.ideCust', '=', 'balance_taking.cust_id')
            ->orWhereDate('updated_at', Carbon::today())
            ->groupBy('cust_id')->get();

        $todayCustIdArr = []; // all submitted data by today
        foreach ($btData as $bt) {
            $btVisityDay = $bt->visit_day - 1;
            if ($dayOfWeek == $btVisityDay) {
                array_push($todayCustIdArr, $bt->cust_id);
            }
        }

        $audience = "GPRIC";
        $payoutData = Payout::where('SubChain', 'like', '%' . $audience . '%')->get();

        $todaySubmittedArr = [];
        $todayNotSubmittedArr = [];
        $thisWeekOutletArr = [];
        $earlyOutletArr = [];

        $actualyVisityDay = 0;
        foreach ($payoutData as $payout) {

            $custId = $payout->ideCust;
            $visityDay = $payout->visit_day;

            //before visity day
            $beforeVisityDayofWeek = $visityDay - 1;
            if ($dayOfWeek == $beforeVisityDayofWeek) {
                $actualyVisityDay = $visityDay;
                echo "Before - $custId - $beforeVisityDayofWeek (Actual: $visityDay) <br>";
                array_push($thisWeekOutletArr, $custId); // this visity day all data
                if (in_array($custId, $todayCustIdArr)) {
                    array_push($todaySubmittedArr, $custId);
                } else {
                    array_push($todayNotSubmittedArr, $custId);
                }
            }
        }

        //re-catch the submitted data but not submitted by current date
        foreach ($thisWeekOutletArr as $thisWeekCustId) {
            $btCustIdData = BalanceTaking::where('cust_id', $thisWeekCustId)->orderBy('weekno', 'desc')->first();

            $custId = $btCustIdData->cust_id;
            $createdAtDate = $btCustIdData->created_at->format('Y-m-d');
            $updatedAtDate = (!empty($btCustIdData->updated_at)) ? $btCustIdData->updated_at->format('Y-m-d') : "";

            if ($createdAtDate  != Carbon::today()->format('Y-m-d')) {
                if ($updatedAtDate  != Carbon::today()->format('Y-m-d')) {

                    $lastCreatedAtDate = Carbon::parse($createdAtDate);
                    $now = Carbon::now();
                    $diffDays = $lastCreatedAtDate->diffInDays($now);

                    if ($diffDays < 7) {
                        array_push($todaySubmittedArr, $custId);
                    }
                }
            }
        }

        foreach ($thisWeekOutletArr as $thisWeekCustId) {

            $btCustIdData = BalanceTaking::where('cust_id', $thisWeekCustId)->orderBy('weekno', 'desc')->first();

            $custId = $btCustIdData->cust_id;
            $createdAt = $btCustIdData->created_at->format('Y-m-d');
            $updatedAt = (!empty($btCustIdData->updated_at)) ? $btCustIdData->updated_at->format('Y-m-d') : "";

            echo "<br>$custId - $createdAt -" . Carbon::today();
            if ($createdAt  != Carbon::today()->format('Y-m-d')) {
                if ($updatedAt  != Carbon::today()->format('Y-m-d')) {
                    if (!in_array($custId, $todayNotSubmittedArr)) {
                        array_push($todayNotSubmittedArr, $custId);
                    }
                }
            }
        }


        foreach ($thisWeekOutletArr as $thisWeekCustId) {

            $btCustIdData = BalanceTaking::where('cust_id', $thisWeekCustId)->orderBy('weekno', 'desc')->first();

            $custId = $btCustIdData->cust_id;
            $createdAt = $btCustIdData->created_at->format('Y-m-d');
            $updatedAt = (!empty($btCustIdData->updated_at)) ? $btCustIdData->updated_at->format('Y-m-d') : "";

            $lastCreatedAt = Carbon::parse($createdAt);
            $now = Carbon::now();
            $diff = $lastCreatedAt->diffInDays($now);

            // if recently submitted for example today is Nov 2, then Nov 1 submitted
            if ($diff < 7) {
                if (($key = array_search($custId, $todayNotSubmittedArr)) !== false) {
                    unset($todayNotSubmittedArr[$key]);
                }
            }
        }

        // early 
        $earlyOutletArr = [];
        foreach ($todayCustIdArr as $todayCustId) { // loop submitted data
            $custId = $todayCustId;
            if (!in_array($custId, $thisWeekOutletArr)) { // if submitted data is not in the visity day list, then consider early outlet
                array_push($earlyOutletArr, $custId);
            }
        }

        $numberOutletSubmitted = count($todaySubmittedArr);
        $numberOutletSendReminderSMS =  count($todayNotSubmittedArr);
        $numberEarlySubmitted = count($earlyOutletArr);

        // Generate table data
        $todaySubmittedData = Payout::select('ideCust', 'strName', 'strAddr')->whereIn('ideCust', $todaySubmittedArr)->get();
        $todayNotSubmittedData = Payout::select('ideCust', 'strName', 'strAddr', 'mobile_no')->whereIn('ideCust', $todayNotSubmittedArr)->get();
        $earlyData = Payout::select('ideCust', 'strName', 'strAddr')->whereIn('ideCust', $earlyOutletArr)->get();


        // SMS message
        foreach ($todayNotSubmittedData as $notSubmittedData) {
            $custId = $notSubmittedData->ideCust;
            $mobileNo = "65" . $notSubmittedData->mobile_no;

            $message = "";
            $message .= "It is important to maintain a healthy in-store inventory so not to have out of stock situation. You have yet to complete the balance taking task this week. Login to sg.pmiandu.com to input the instore balance inventory of NEXT Red, Blue, Menthol, Red XL, Blue XL as well as Menthol XL before 9pm today.";
            $message .= "\n\n\n";
            $message .= "保持店库存在健康水平，以免出现缺货情况！您未完成这个星期的点货任务。请在今天晚上9点之前，登录 sg.pmiandu.com 输入您店里 NEXT Red，Blue，Menthol，Red XL，Blue XL 和 Menthol XL 的库存余额。";

            $sms = new SmsDome();

            //Testing

            //if ($mobileNo == "6598109360") {
            //echo "!!!" . $mobileNo . "<br>" . $message;
            if ($sms->send_sms($mobileNo, $message)) {
                $log->info($custId . '---' . $mobileNo . ' msg success delivered (' . $message . ')');
            } else {
                $log->warning($custId . '---' . $mobileNo . ' msg not delivered (' . $message . ')');
            }
        }

        $dMFormat = Carbon::now()->format('d M');

        $dayName = "";
        switch ($actualyVisityDay) {
            case 1:
                $dayName = "Mon";
                break;
            case 2:
                $dayName = "Tue";
                break;
            case 3:
                $dayName = "Wed";
                break;
            case 4:
                $dayName = "Thu";
                break;
            case 5:
                $dayName = "Fri";
                break;
        }

        $data = [
            "today_date" => $dMFormat,
            "total_outlet" => count($thisWeekOutletArr),
            "day_name" => $dayName,
            "num_outlet_submitted" => $numberOutletSubmitted,
            "num_outlet_send_reminder_sms" => $numberOutletSendReminderSMS,
            "num_early_submitted" => $numberEarlySubmitted,
            "today_submitted_data" => $todaySubmittedData,
            "today_not_submitted_data" => $todayNotSubmittedData,
            "early_data" => $earlyData
        ];

        //$emails = ['samrong.tee@onyxisland.com'];
        //$emails = ['danny.murong@onyxisland.com', 'serene.lai@onyxisland.com', 'samrong.tee@onyxisland.com'];
        //$ccEmails = ['samrong.tee@onyxisland.com'];

        $emails = [
            'YongHui.Yeo@pmi.com',
            'amanda.lim@pmi.com',
            'junie.juan@pmi.com',
            'jaelynn.tan@pmi.com',
            'mariacristina.garde@pmi.com',
            'Roxanne.Yew@contracted.pmi.com',
            'jhanyong.wan@pmi.com',
            'Vivian.Quark@pmi.com',
            'Alvin.Ng@pmi.com'
        ];

        $ccEmails = [
            'danny.murong@onyxisland.com',
            'serene.lai@onyxisland.com',
            'anna.ramos@onyxisland.com',
            'samrong.tee@onyxisland.com'
        ];

        Mail::send('emails.balance-taking', $data, function ($message)  use ($emails, $ccEmails) {

            $message->to($emails)->cc($ccEmails)
                ->subject('PMI – Daily Balance Taking Report ' . Carbon::now()->format('d M'))
                //->attachData((new FastExcel($this->dataGenerator()))->export('abc.csv'), 'Test_Name.csv');
                ->attach((new FastExcel($this->dataGenerator()))->export('Balance_Taking_' . date('Ymd') . '.xlsx'), [
                    'mime' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    //'mime' => 'text/csv',
                ]);
        });

        if (Mail::failures()) {
            $log->critical('Balance Taking Email send failed.', []);
            dd('Reset Email reminder send failed.');
        } else {
            $log->info('Balance Taking Email send successfully.', []);
            dd('Reset Email reminder send successfully.');
        }
    }

    public function dataGenerator()
    {

        $query = DB::connection('mysql')->table('balance_taking')
            ->select(['balance_taking.id', 'cust_id', 'sku_id', 'balance_taking_sku.sku_name as sku_name', 'qty_packs', 'weekno', 'fe_weekno', 'created_at', 'updated_at'])
            ->join('balance_taking_sku', 'balance_taking_sku.id', '=', 'balance_taking.sku_id');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }
}
